/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.util;

import com.feilong.net.mail.exception.MailException;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;

public class MessageSendUtil {
    private MessageSendUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void send(Message message) {
        MessageSendUtil.setDefaultCommandMap();
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private static void setDefaultCommandMap() {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mailcapCommandMap.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mailcapCommandMap.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mailcapCommandMap.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mailcapCommandMap.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }
}

