/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.util;

import com.feilong.core.CharsetType;
import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

public final class InternetAddressUtil {
    private static final String CHARSET_PERSONAL = CharsetType.UTF8;

    private InternetAddressUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Address[] toAddressArray(String[] addresseArray) throws AddressException {
        int length = addresseArray.length;
        InternetAddress[] addresses = new InternetAddress[length];
        for (int i = 0; i < length; ++i) {
            addresses[i] = new InternetAddress(addresseArray[i]);
        }
        return addresses;
    }

    public static final InternetAddress[] toInternetAddressArray(Map<String, String> nameAndEmailMap, String charset) throws UnsupportedEncodingException {
        Validate.notEmpty(nameAndEmailMap, "nameAndEmailMap can't be null/empty!", new Object[0]);
        InternetAddress[] internetAddresses = new InternetAddress[nameAndEmailMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : nameAndEmailMap.entrySet()) {
            String name = entry.getKey();
            String email = entry.getValue();
            internetAddresses[i] = new InternetAddress(email, name, charset);
            ++i;
        }
        return internetAddresses;
    }

    public static final List<String> toUnicodeStringList(InternetAddress[] internetAddresses) {
        Validate.notEmpty(internetAddresses, "internetAddresses can't be null/empty!", new Object[0]);
        List<String> list = CollectionsUtil.newArrayList();
        for (InternetAddress internetAddress : internetAddresses) {
            list.add(internetAddress.toUnicodeString());
        }
        return list;
    }

    public static Address buildFromAddress(String personal, String fromAddress) {
        Validate.notBlank(fromAddress, "fromAddress can't be blank!", new Object[0]);
        try {
            if (Validator.isNotNullOrEmpty(personal)) {
                String encoding = "b";
                String encodeText = MimeUtility.encodeText((String)personal, (String)CHARSET_PERSONAL, (String)encoding);
                return new InternetAddress(fromAddress, encodeText);
            }
            return new InternetAddress(fromAddress);
        }
        catch (UnsupportedEncodingException | AddressException e) {
            throw new DefaultRuntimeException(Slf4jUtil.format("personal:[{}],fromAddress:[{}]", personal, fromAddress), e);
        }
    }
}

