/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.builder.setter;

import com.feilong.net.mail.builder.setter.AttachmentSetter;
import com.feilong.net.mail.entity.MailSendRequest;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class BodySetter {
    private BodySetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void setBody(Message message, MailSendRequest mailSendRequest) throws MessagingException {
        if (null == mailSendRequest.getContent()) {
            mailSendRequest.setContent("");
        }
        MimeMultipart mimeMultipart = BodySetter.buildContent(mailSendRequest);
        message.setContent((Multipart)mimeMultipart);
    }

    private static MimeMultipart buildContent(MailSendRequest mailSendRequest) throws MessagingException {
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart(BodySetter.buildHtmlContentBody(mailSendRequest));
        AttachmentSetter.setAttachment(mimeMultipart, mailSendRequest.getAttachFileLocations());
        return mimeMultipart;
    }

    private static BodyPart buildHtmlContentBody(MailSendRequest mailSendRequest) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)mailSendRequest.getContent(), mailSendRequest.getContentMimeType());
        return bodyPart;
    }
}

