/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.builder.setter;

import com.feilong.core.Validator;
import com.feilong.io.FilenameUtil;
import com.feilong.io.InputStreamUtil;
import com.feilong.io.entity.MimeType;
import com.feilong.lib.io.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public final class AttachmentSetter {
    public static final String PREFIX_CONTENTID = "image";

    private AttachmentSetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void setAttachment(MimeMultipart mimeMultipart, String[] attachFileLocations) throws MessagingException {
        if (Validator.isNullOrEmpty(attachFileLocations)) {
            return;
        }
        System.setProperty("mail.mime.encodefilename", "true");
        mimeMultipart.setSubType("related");
        int i = 0;
        for (String attachFileLocation : attachFileLocations) {
            String fileName = FilenameUtil.getFileName(attachFileLocation);
            try {
                byte[] byteArray = IOUtils.toByteArray(InputStreamUtil.getInputStream(attachFileLocation));
                mimeMultipart.addBodyPart((BodyPart)AttachmentSetter.buildMimeBodyPart(fileName, byteArray, PREFIX_CONTENTID + i));
                ++i;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static MimeBodyPart buildMimeBodyPart(String fileName, byte[] data, String cid) throws MessagingException {
        String mimeType = MimeType.BIN.getMime();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(AttachmentSetter.buildDataHandler(data, mimeType));
        mimeBodyPart.setFileName(fileName);
        mimeBodyPart.setContentID(cid);
        return mimeBodyPart;
    }

    private static DataHandler buildDataHandler(byte[] data, String mimeType) {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(data, mimeType);
        return new DataHandler((DataSource)byteArrayDataSource);
    }
}

