/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.builder;

import com.feilong.core.Validator;
import com.feilong.core.lang.ClassUtil;
import com.feilong.json.JsonUtil;
import com.feilong.net.mail.entity.MailSendConnectionConfig;
import com.feilong.net.mail.entity.SessionConfig;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.Properties;

public class SessionPropertiesBuilder {
    private SessionPropertiesBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Properties build(SessionConfig sessionConfig) {
        String serverHost = sessionConfig.getServerHost();
        if (Validator.isNullOrEmpty(serverHost)) {
            throw new IllegalArgumentException(Slf4jUtil.format("serverHost can't be null/empty! sessionConfig:[{}]", JsonUtil.format(sessionConfig)));
        }
        Properties properties = new Properties();
        properties.put("mail.smtp.host", serverHost);
        String serverPort = sessionConfig.getServerPort();
        if (Validator.isNotNullOrEmpty(serverPort)) {
            properties.put("mail.smtp.port", serverPort);
        }
        properties.put("mail.smtp.auth", sessionConfig.getIsValidate() ? "true" : "false");
        if (ClassUtil.isInstance(sessionConfig, MailSendConnectionConfig.class)) {
            MailSendConnectionConfig mailSendConnectionConfig = (MailSendConnectionConfig)sessionConfig;
            if (mailSendConnectionConfig.getIsSmtpSSLEnable()) {
                SessionPropertiesBuilder.setSSL(properties);
            }
            if (mailSendConnectionConfig.getIsSmtpStarttlsEnable()) {
                SessionPropertiesBuilder.setStarttls(properties);
            }
        }
        return properties;
    }

    private static void setSSL(Properties properties) {
        properties.put("mail.smtp.ssl.enable", "true");
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
    }

    private static void setStarttls(Properties properties) {
        properties.put("mail.smtp.starttls.enable", "true");
    }
}

