/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.builder;

import com.feilong.core.date.DateUtil;
import com.feilong.json.JsonUtil;
import com.feilong.net.mail.SessionFactory;
import com.feilong.net.mail.builder.setter.BodySetter;
import com.feilong.net.mail.builder.setter.HeaderSetter;
import com.feilong.net.mail.builder.setter.RecipientsSetter;
import com.feilong.net.mail.entity.MailSendConnectionConfig;
import com.feilong.net.mail.entity.MailSendRequest;
import com.feilong.net.mail.exception.MailException;
import com.feilong.net.mail.util.InternetAddressUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public class MessageBuilder {
    private MessageBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Message build(MailSendRequest mailSendRequest, MailSendConnectionConfig mailSendConnectionConfig) {
        Session session = SessionFactory.createSession(mailSendConnectionConfig);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom(InternetAddressUtil.buildFromAddress(mailSendRequest.getPersonal(), mailSendRequest.getFromAddress()));
            MessageBuilder.setMessageAttribute((Message)message, mailSendRequest);
            BodySetter.setBody((Message)message, mailSendRequest);
        }
        catch (MessagingException e) {
            throw new MailException(Slf4jUtil.format("mailSenderConfig:[{}]", JsonUtil.format(mailSendRequest)), e);
        }
        return message;
    }

    private static void setMessageAttribute(Message message, MailSendRequest mailSendRequest) throws MessagingException {
        RecipientsSetter.setRecipients(message, mailSendRequest);
        message.setSubject(mailSendRequest.getSubject());
        HeaderSetter.setHeaders(message, mailSendRequest);
        message.setSentDate(DateUtil.now());
    }
}

