/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail;

import com.feilong.core.Validate;
import com.feilong.net.mail.builder.AuthenticatorBuilder;
import com.feilong.net.mail.builder.SessionPropertiesBuilder;
import com.feilong.net.mail.entity.SessionConfig;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;

public class SessionFactory {
    private SessionFactory() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Session createSession(SessionConfig sessionConfig) {
        Validate.notNull(sessionConfig, "sessionConfig can't be null!", new Object[0]);
        Authenticator authenticator = AuthenticatorBuilder.build(sessionConfig);
        Properties properties = SessionPropertiesBuilder.build(sessionConfig);
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)authenticator);
        session.setDebug(sessionConfig.getIsDebug());
        return session;
    }
}

