/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail;

import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import com.feilong.net.mail.MailReader;
import com.feilong.net.mail.SessionFactory;
import com.feilong.net.mail.entity.MailInfo;
import com.feilong.net.mail.entity.MailReaderConfig;
import com.feilong.net.mail.exception.MailException;
import com.feilong.net.mail.util.FolderUtil;
import com.feilong.net.mail.util.MessageUtil;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPMailReader
implements MailReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(IMAPMailReader.class);
    private static final String PROTOCOL = "imap";
    private static final String FOLDER_NAME = "INBOX";

    @Override
    public List<MailInfo> read(MailReaderConfig mailReaderConfig) {
        return this.read(mailReaderConfig, null, null);
    }

    @Override
    public List<MailInfo> read(MailReaderConfig mailReaderConfig, Integer newstIndex, SearchTerm searchTerm) {
        List<MailInfo> list;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("input mailReaderConfig:[{}],searchTerm:[{}]", (Object)JsonUtil.format(mailReaderConfig), (Object)JsonUtil.format(searchTerm));
        }
        String mailServerHost = mailReaderConfig.getServerHost();
        String userName = mailReaderConfig.getUserName();
        String password = mailReaderConfig.getPassword();
        Session session = SessionFactory.createSession(mailReaderConfig);
        Store store = null;
        Folder folder = null;
        try {
            store = session.getStore(PROTOCOL);
            store.connect(mailServerHost, userName, password);
            folder = IMAPMailReader.getFolder(store);
            Message[] messages = IMAPMailReader.getMessages(folder, searchTerm, newstIndex);
            list = MessageUtil.toMailInfoList(messages);
        }
        catch (MessagingException e) {
            try {
                throw new MailException(e);
            }
            catch (Throwable throwable) {
                IMAPMailReader.close(store);
                IMAPMailReader.close(folder);
                throw throwable;
            }
        }
        IMAPMailReader.close(store);
        IMAPMailReader.close(folder);
        return list;
    }

    private static void close(Store store) {
        try {
            if (null != store && store.isConnected()) {
                store.close();
            }
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private static void close(Folder folder) {
        try {
            if (null != folder && folder.isOpen()) {
                folder.close(false);
            }
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private static Folder getFolder(Store store) throws MessagingException {
        Folder folder = store.getFolder(FOLDER_NAME);
        folder.open(1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("folder info :{}", (Object)JsonUtil.format(FolderUtil.getMapForLog(folder)));
        }
        return folder;
    }

    private static Message[] getMessages(Folder folder, SearchTerm searchTerm, Integer newstIndex) throws MessagingException {
        Message[] messages = null;
        if (Validator.isNotNullOrEmpty(newstIndex)) {
            int messageCount = folder.getMessageCount();
            int start = messageCount - newstIndex;
            start = start < 1 ? 1 : start;
            messages = folder.getMessages(start, messageCount);
        } else {
            messages = folder.getMessages();
        }
        return Validator.isNullOrEmpty(searchTerm) ? messages : folder.search(searchTerm, messages);
    }
}

