/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.callback;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.date.DateUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.formatter.FormatterUtil;
import com.feilong.json.JavaToJsonConfig;
import com.feilong.json.JsonUtil;
import com.feilong.json.processor.StringOverLengthJsonValueProcessor;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.HttpRequest;
import com.feilong.net.http.HttpResponse;
import com.feilong.net.http.builder.HttpResponseUtil;
import com.feilong.net.http.callback.ResultCallback;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseResultCallback
implements ResultCallback<HttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseResultCallback.class);
    public static final HttpResponseResultCallback INSTANCE = new HttpResponseResultCallback();

    @Override
    public HttpResponse on(HttpRequest httpRequest, HttpUriRequest httpUriRequest, org.apache.http.HttpResponse httpResponse, ConnectionConfig useConnectionConfig, Date beginDate) {
        HttpResponse resultResponse = HttpResponseResultCallback.build(beginDate, httpResponse);
        if (LOGGER.isInfoEnabled()) {
            String pattern = "request:[{}],useConnectionConfig:[{}],response:[{}]";
            String response = JsonUtil.format((Object)resultResponse, new JavaToJsonConfig(ConvertUtil.toMap("resultString", new StringOverLengthJsonValueProcessor())));
            LOGGER.info(pattern, new Object[]{JsonUtil.format(httpRequest), JsonUtil.format(useConnectionConfig), response});
        }
        return resultResponse;
    }

    private static HttpResponse build(Date beginDate, org.apache.http.HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        HttpResponse result = new HttpResponse();
        result.setStatusCode(statusLine.getStatusCode());
        result.setHeaderMap(HttpResponseResultCallback.convert(httpResponse.getAllHeaders()));
        result.setResultString(HttpResponseUtil.getResultString(httpResponse));
        result.setUseTime(DateUtil.getIntervalTime(beginDate, DateUtil.now()));
        return result;
    }

    private static Map<String, String> convert(Header[] allHeaders) {
        if (Validator.isNullOrEmpty(allHeaders)) {
            return Collections.emptyMap();
        }
        Map<String, String> map = MapUtil.newTreeMap();
        for (Header header : allHeaders) {
            String name = header.getName();
            if (!Validator.isNotNullOrEmpty(name)) continue;
            map.put(name, header.getValue());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(FormatterUtil.formatToSimpleTable(map));
        }
        return map;
    }
}

