/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder.httpurirequest;

import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import com.feilong.net.UncheckedHttpException;
import com.feilong.net.http.HttpRequest;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class URIBuilderBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIBuilderBuilder.class);

    private URIBuilderBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static URIBuilder build(HttpRequest httpRequest) {
        try {
            String uri = httpRequest.getUri();
            URIBuilder uriBuilder = new URIBuilder(uri);
            Map<String, String> paramMap = httpRequest.getParamMap();
            if (Validator.isNullOrEmpty(paramMap)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("httpRequest [paramMap] is isNullOrEmpty,skip!,httpRequest info:[{}]", (Object)JsonUtil.format(httpRequest));
                }
                return uriBuilder;
            }
            return URIBuilderBuilder.buildWithParameters(uriBuilder, paramMap);
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("httpRequest:[{}]", JsonUtil.format(httpRequest));
            throw new UncheckedHttpException(message, e);
        }
    }

    private static URIBuilder buildWithParameters(URIBuilder uriBuilder, Map<String, String> paramMap) {
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("httpUriRequest.setHeader({}, {})", (Object)key, (Object)value);
            }
            uriBuilder.setParameter(key, value);
        }
        return uriBuilder;
    }
}

