/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.filetransfer.sftp;

import com.feilong.core.Validate;
import com.feilong.core.util.MapUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import com.jcraft.jsch.Session;
import java.util.Map;

class SftpSessionUtil {
    private SftpSessionUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static final String buildSessionPrettyString(Session session) {
        Validate.notNull(session, "session can't be null!", new Object[0]);
        return Slf4jUtil.format("{}@{}:{}", session.getUserName(), session.getHost(), session.getPort());
    }

    static final Map<String, Object> getMapForLog(Session session) {
        Map<String, Object> map = MapUtil.newLinkedHashMap();
        map.put("clientVersion", session.getClientVersion());
        map.put("serverVersion", session.getServerVersion());
        map.put("serverAliveCountMax", session.getServerAliveCountMax());
        map.put("serverAliveInterval", session.getServerAliveInterval());
        map.put("timeout", session.getTimeout());
        return map;
    }
}

