/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.cxf;

import com.feilong.core.Validate;
import com.feilong.core.util.MapUtil;
import com.feilong.json.JsonUtil;
import com.feilong.net.cxf.ClientUtil;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxWsDynamicClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxWsDynamicClientUtil.class);

    private JaxWsDynamicClientUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void setDefaultHostnameVerifierTrue() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public static <T> T call(String wsdlUrl, String operationName, Object ... params) {
        Validate.notBlank(wsdlUrl, "wsdlUrl can't be blank!", new Object[0]);
        if (LOGGER.isInfoEnabled()) {
            Map<String, Object> traceMap = JaxWsDynamicClientUtil.getTraceMapForLog(wsdlUrl, operationName, params);
            LOGGER.info("will call webservice,input infos:{}", (Object)JsonUtil.format(traceMap));
        }
        Client client = JaxWsDynamicClientUtil.createClient(wsdlUrl);
        try {
            Object[] obj = client.invoke(operationName, params);
            return (T)obj[0];
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    static Client createClient(String wsdlUrl) {
        JaxWsDynamicClientFactory dynamicClientFactory = JaxWsDynamicClientFactory.newInstance();
        Client client = dynamicClientFactory.createClient(wsdlUrl);
        ClientUtil.wrap(client);
        return client;
    }

    private static Map<String, Object> getTraceMapForLog(String wsdlUrl, String operationName, Object ... params) {
        Map<String, Object> object = MapUtil.newLinkedHashMap();
        object.put("wsdlUrl", wsdlUrl);
        object.put("operationName", operationName);
        object.put("params", params);
        return object;
    }

    static {
        JaxWsDynamicClientUtil.setDefaultHostnameVerifierTrue();
    }
}

