/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.namespace;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.w3c.dom.Element;

public class BeanDefinitionParserUtil {
    private BeanDefinitionParserUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void addPropertyValue(Element element, BeanDefinitionBuilder beanDefinitionBuilder, String attributeName, boolean required) {
        Validate.notBlank(attributeName, "name can't be blank!,element:[%s]", element.toString());
        if (!element.hasAttribute(attributeName)) {
            if (required) {
                throw new IllegalArgumentException("must config attributeName:[" + attributeName + "]");
            }
            return;
        }
        String value = element.getAttribute(attributeName);
        if (required) {
            Validate.notBlank(value, "when name is :[%s],value can't be blank!", attributeName);
        }
        if (Validator.isNotNullOrEmpty(value)) {
            beanDefinitionBuilder.addPropertyValue(attributeName, (Object)value);
        }
    }

    public static void addPropertyValue(Element element, RootBeanDefinition rootBeanDefinition, String attributeName, boolean required) {
        Validate.notBlank(attributeName, "name can't be blank!,element:[%s]", element.toString());
        if (!element.hasAttribute(attributeName)) {
            if (required) {
                throw new IllegalArgumentException("must config attributeName:[" + attributeName + "]");
            }
            return;
        }
        String value = element.getAttribute(attributeName);
        if (required) {
            Validate.notBlank(value, "when name is :[%s],value can't be blank!", attributeName);
        }
        if (Validator.isNotNullOrEmpty(value)) {
            rootBeanDefinition.getPropertyValues().addPropertyValue(attributeName, (Object)value);
        }
    }

    public static void addPropertyValue(Element element, BeanDefinitionBuilder beanDefinitionBuilder, String ... attributeNameList) {
        for (String attributeName : attributeNameList) {
            BeanDefinitionParserUtil.add(element, beanDefinitionBuilder, attributeName);
        }
    }

    private static void add(Element element, BeanDefinitionBuilder beanDefinitionBuilder, String attributeName) {
        BeanDefinitionParserUtil.addPropertyValue(element, beanDefinitionBuilder, attributeName, false);
    }
}

