/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json.util;

import com.feilong.core.lang.ClassUtil;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.json.JsonConfig;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertySetStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertySetStrategy.class);
    public static final PropertySetStrategy DEFAULT = new DefaultPropertySetStrategy();

    public abstract void setProperty(Object var1, String var2, Object var3);

    public void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) {
        this.setProperty(bean, key, value);
    }

    private static final class DefaultPropertySetStrategy
    extends PropertySetStrategy {
        private DefaultPropertySetStrategy() {
        }

        @Override
        public void setProperty(Object bean, String key, Object value) {
            this.setProperty(bean, key, value, new JsonConfig());
        }

        @Override
        public void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) {
            if (bean instanceof Map) {
                ((Map)bean).put(key, value);
                return;
            }
            try {
                PropertyUtils.setSimpleProperty(bean, key, value);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (ClassUtil.isInstance(cause, NoSuchMethodException.class)) {
                    LOGGER.warn("in class:[{}],can't find property:[{}],now ignore~~", (Object)bean.getClass().getName(), (Object)key);
                }
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

