/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.processors.DefaultDefaultValueProcessor;
import com.feilong.lib.json.processors.DefaultValueProcessor;
import com.feilong.lib.json.processors.JsonBeanProcessor;
import com.feilong.lib.json.processors.JsonBeanProcessorMatcher;
import com.feilong.lib.json.processors.JsonValueProcessor;
import com.feilong.lib.json.processors.PropertyNameProcessor;
import com.feilong.lib.json.processors.PropertyNameProcessorMatcher;
import com.feilong.lib.json.util.CycleDetectionStrategy;
import com.feilong.lib.json.util.JavaIdentifierTransformer;
import com.feilong.lib.json.util.PropertyFilter;
import com.feilong.lib.lang3.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonConfig {
    private static final JsonBeanProcessorMatcher DEFAULT_JSON_BEAN_PROCESSOR_MATCHER = JsonBeanProcessorMatcher.DEFAULT;
    private static final PropertyNameProcessorMatcher DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER = PropertyNameProcessorMatcher.DEFAULT;
    private static final JavaIdentifierTransformer DEFAULT_JAVA_IDENTIFIER_TRANSFORMER = JavaIdentifierTransformer.NOOP;
    private static final DefaultValueProcessor DEFAULT_VALUE_PROCESSOR = DefaultDefaultValueProcessor.INSTANCE;
    private static final CycleDetectionStrategy DEFAULT_CYCLE_DETECTION = CycleDetectionStrategy.LENIENT;
    private static final String[] DEFAULT_EXCLUDES = ConvertUtil.toArray("class", "declaringClass", "metaClass");
    private static final int MODE_LIST = 1;
    public static final int MODE_OBJECT_ARRAY = 2;
    private static final int MODE_SET = 2;
    private int arrayMode = 1;
    private final Map<Class<?>, JsonBeanProcessor> beanProcessorMap = new HashMap();
    private String[] excludes = ArrayUtil.EMPTY_STRING_ARRAY;
    private final Map<Class<?>, DefaultValueProcessor> defaultValueMap = new HashMap();
    private boolean ignoreDefaultExcludes = false;
    private JavaIdentifierTransformer javaIdentifierTransformer = DEFAULT_JAVA_IDENTIFIER_TRANSFORMER;
    private PropertyFilter javaPropertyFilter;
    private Class<?> collectionType = List.class;
    private CycleDetectionStrategy cycleDetectionStrategy = DEFAULT_CYCLE_DETECTION;
    private final Map<Class<?>, PropertyNameProcessor> javaPropertyNameProcessorMap = new HashMap();
    private final Map<String, JsonValueProcessor> keyMap = new HashMap<String, JsonValueProcessor>();
    private final Map<Class<?>, JsonValueProcessor> typeMap = new HashMap();
    private PropertyNameProcessorMatcher javaPropertyNameProcessorMatcher = DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER;
    private JsonBeanProcessorMatcher jsonBeanProcessorMatcher = DEFAULT_JSON_BEAN_PROCESSOR_MATCHER;
    private PropertyFilter jsonPropertyFilter;
    private final Map<Class<?>, PropertyNameProcessor> jsonPropertyNameProcessorMap = new HashMap();
    private PropertyNameProcessorMatcher jsonPropertyNameProcessorMatcher = DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER;
    private Class<?> rootClass;
    private Map<String, Class<?>> classMap;

    public DefaultValueProcessor findDefaultValueProcessor(Class<?> target) {
        DefaultValueProcessor processor;
        if (!this.defaultValueMap.isEmpty() && (processor = this.defaultValueMap.get(target)) != null) {
            return processor;
        }
        return DEFAULT_VALUE_PROCESSOR;
    }

    public PropertyNameProcessor findJavaPropertyNameProcessor(Class<?> beanClass) {
        if (!this.javaPropertyNameProcessorMap.isEmpty()) {
            Object key = this.javaPropertyNameProcessorMatcher.getMatch(beanClass, this.javaPropertyNameProcessorMap.keySet());
            return this.javaPropertyNameProcessorMap.get(key);
        }
        return null;
    }

    public JsonBeanProcessor findJsonBeanProcessor(Class<?> target) {
        if (!this.beanProcessorMap.isEmpty()) {
            Class<?> key = this.jsonBeanProcessorMatcher.getMatch(target, this.beanProcessorMap.keySet());
            return this.beanProcessorMap.get(key);
        }
        return null;
    }

    public PropertyNameProcessor findJsonPropertyNameProcessor(Class<?> beanClass) {
        if (!this.jsonPropertyNameProcessorMap.isEmpty()) {
            Object key = this.jsonPropertyNameProcessorMatcher.getMatch(beanClass, this.jsonPropertyNameProcessorMap.keySet());
            return this.jsonPropertyNameProcessorMap.get(key);
        }
        return null;
    }

    public JsonValueProcessor findJsonValueProcessor(Class<?> propertyType) {
        return this.typeMap.get(propertyType);
    }

    public JsonValueProcessor findJsonValueProcessor(Class<?> beanClass, Class<?> propertyType, String key) {
        JsonValueProcessor jsonValueProcessor = this.keyMap.get(key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return this.typeMap.get(propertyType);
    }

    public JsonValueProcessor findJsonValueProcessor(Class<?> propertyType, String key) {
        JsonValueProcessor jsonValueProcessor = null;
        jsonValueProcessor = this.keyMap.get(key);
        if (jsonValueProcessor != null) {
            return jsonValueProcessor;
        }
        return this.typeMap.get(propertyType);
    }

    public int getArrayMode() {
        return this.arrayMode;
    }

    public Map<String, Class<?>> getClassMap() {
        return this.classMap;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public CycleDetectionStrategy getCycleDetectionStrategy() {
        return this.cycleDetectionStrategy;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public JavaIdentifierTransformer getJavaIdentifierTransformer() {
        return this.javaIdentifierTransformer;
    }

    public PropertyFilter getJavaPropertyFilter() {
        return this.javaPropertyFilter;
    }

    public PropertyNameProcessorMatcher getJavaPropertyNameProcessorMatcher() {
        return this.javaPropertyNameProcessorMatcher;
    }

    public JsonBeanProcessorMatcher getJsonBeanProcessorMatcher() {
        return this.jsonBeanProcessorMatcher;
    }

    public PropertyFilter getJsonPropertyFilter() {
        return this.jsonPropertyFilter;
    }

    public Collection<String> getMergedExcludes() {
        int i;
        HashSet<String> exclusions = new HashSet<String>();
        for (i = 0; i < this.excludes.length; ++i) {
            String exclusion = this.excludes[i];
            if (StringUtils.isBlank(exclusion)) continue;
            exclusions.add(exclusion.trim());
        }
        if (!this.ignoreDefaultExcludes) {
            for (i = 0; i < DEFAULT_EXCLUDES.length; ++i) {
                if (exclusions.contains(DEFAULT_EXCLUDES[i])) continue;
                exclusions.add(DEFAULT_EXCLUDES[i]);
            }
        }
        return exclusions;
    }

    public Class<?> getRootClass() {
        return this.rootClass;
    }

    public void registerDefaultValueProcessor(Class<?> target, DefaultValueProcessor defaultValueProcessor) {
        if (target != null && defaultValueProcessor != null) {
            this.defaultValueMap.put(target, defaultValueProcessor);
        }
    }

    public void registerJavaPropertyNameProcessor(Class<?> target, PropertyNameProcessor propertyNameProcessor) {
        if (target != null && propertyNameProcessor != null) {
            this.javaPropertyNameProcessorMap.put(target, propertyNameProcessor);
        }
    }

    public void registerJsonBeanProcessor(Class<?> target, JsonBeanProcessor jsonBeanProcessor) {
        if (target != null && jsonBeanProcessor != null) {
            this.beanProcessorMap.put(target, jsonBeanProcessor);
        }
    }

    public void registerJsonPropertyNameProcessor(Class<?> target, PropertyNameProcessor propertyNameProcessor) {
        if (target != null && propertyNameProcessor != null) {
            this.jsonPropertyNameProcessorMap.put(target, propertyNameProcessor);
        }
    }

    public void registerJsonValueProcessor(Class<?> propertyType, JsonValueProcessor jsonValueProcessor) {
        if (propertyType != null && jsonValueProcessor != null) {
            this.typeMap.put(propertyType, jsonValueProcessor);
        }
    }

    public void registerJsonValueProcessor(String key, JsonValueProcessor jsonValueProcessor) {
        if (key != null && jsonValueProcessor != null) {
            this.keyMap.put(key, jsonValueProcessor);
        }
    }

    public void setArrayMode(int arrayMode) {
        if (arrayMode == 2) {
            this.arrayMode = arrayMode;
        } else if (arrayMode == 2) {
            this.arrayMode = arrayMode;
            this.collectionType = Set.class;
        } else {
            this.arrayMode = 1;
        }
    }

    public void setClassMap(Map<String, Class<?>> classMap) {
        this.classMap = classMap;
    }

    public void setCollectionType(Class<?> collectionType) {
        if (collectionType != null) {
            if (!Collection.class.isAssignableFrom(collectionType)) {
                throw new JSONException("The configured collectionType is not a Collection: " + collectionType.getName());
            }
            this.collectionType = collectionType;
        } else {
            collectionType = List.class;
        }
    }

    public void setCycleDetectionStrategy(CycleDetectionStrategy cycleDetectionStrategy) {
        this.cycleDetectionStrategy = ObjectUtil.defaultIfNull(cycleDetectionStrategy, DEFAULT_CYCLE_DETECTION);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes == null ? ArrayUtil.EMPTY_STRING_ARRAY : excludes;
    }

    public void setIgnoreDefaultExcludes(boolean ignoreDefaultExcludes) {
        this.ignoreDefaultExcludes = ignoreDefaultExcludes;
    }

    public void setJavaIdentifierTransformer(JavaIdentifierTransformer javaIdentifierTransformer) {
        this.javaIdentifierTransformer = javaIdentifierTransformer == null ? DEFAULT_JAVA_IDENTIFIER_TRANSFORMER : javaIdentifierTransformer;
    }

    public void setJavaPropertyFilter(PropertyFilter javaPropertyFilter) {
        this.javaPropertyFilter = javaPropertyFilter;
    }

    public void setJavaPropertyNameProcessorMatcher(PropertyNameProcessorMatcher propertyNameProcessorMatcher) {
        this.javaPropertyNameProcessorMatcher = propertyNameProcessorMatcher == null ? DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER : propertyNameProcessorMatcher;
    }

    public void setJsonBeanProcessorMatcher(JsonBeanProcessorMatcher jsonBeanProcessorMatcher) {
        this.jsonBeanProcessorMatcher = jsonBeanProcessorMatcher == null ? DEFAULT_JSON_BEAN_PROCESSOR_MATCHER : jsonBeanProcessorMatcher;
    }

    public void setJsonPropertyFilter(PropertyFilter jsonPropertyFilter) {
        this.jsonPropertyFilter = jsonPropertyFilter;
    }

    public void setJsonPropertyNameProcessorMatcher(PropertyNameProcessorMatcher propertyNameProcessorMatcher) {
        this.jsonPropertyNameProcessorMatcher = propertyNameProcessorMatcher == null ? DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER : propertyNameProcessorMatcher;
    }

    public void setRootClass(Class<?> rootClass) {
        this.rootClass = rootClass;
    }

    public void reset() {
        this.excludes = ArrayUtil.EMPTY_STRING_ARRAY;
        this.ignoreDefaultExcludes = false;
        this.javaIdentifierTransformer = DEFAULT_JAVA_IDENTIFIER_TRANSFORMER;
        this.cycleDetectionStrategy = DEFAULT_CYCLE_DETECTION;
        this.arrayMode = 1;
        this.rootClass = null;
        this.classMap = null;
        this.keyMap.clear();
        this.typeMap.clear();
        this.jsonPropertyFilter = null;
        this.javaPropertyFilter = null;
        this.jsonBeanProcessorMatcher = DEFAULT_JSON_BEAN_PROCESSOR_MATCHER;
        this.defaultValueMap.clear();
        this.collectionType = List.class;
        this.javaPropertyNameProcessorMap.clear();
        this.javaPropertyNameProcessorMatcher = DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER;
        this.jsonPropertyNameProcessorMap.clear();
        this.jsonPropertyNameProcessorMatcher = DEFAULT_PROPERTY_NAME_PROCESSOR_MATCHER;
        this.beanProcessorMap.clear();
    }

    public JsonConfig copy() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.classMap = new HashMap();
        if (this.classMap != null) {
            jsonConfig.classMap.putAll(this.classMap);
        }
        jsonConfig.cycleDetectionStrategy = this.cycleDetectionStrategy;
        if (this.excludes != null) {
            jsonConfig.excludes = new String[this.excludes.length];
            System.arraycopy(this.excludes, 0, jsonConfig.excludes, 0, this.excludes.length);
        }
        jsonConfig.ignoreDefaultExcludes = this.ignoreDefaultExcludes;
        jsonConfig.javaIdentifierTransformer = this.javaIdentifierTransformer;
        jsonConfig.keyMap.putAll(this.keyMap);
        jsonConfig.beanProcessorMap.putAll(this.beanProcessorMap);
        jsonConfig.rootClass = this.rootClass;
        jsonConfig.typeMap.putAll(this.typeMap);
        jsonConfig.jsonPropertyFilter = this.jsonPropertyFilter;
        jsonConfig.javaPropertyFilter = this.javaPropertyFilter;
        jsonConfig.jsonBeanProcessorMatcher = this.jsonBeanProcessorMatcher;
        jsonConfig.defaultValueMap.putAll(this.defaultValueMap);
        jsonConfig.collectionType = this.collectionType;
        jsonConfig.javaPropertyNameProcessorMatcher = this.javaPropertyNameProcessorMatcher;
        jsonConfig.javaPropertyNameProcessorMap.putAll(this.javaPropertyNameProcessorMap);
        jsonConfig.jsonPropertyNameProcessorMatcher = this.jsonPropertyNameProcessorMatcher;
        jsonConfig.jsonPropertyNameProcessorMap.putAll(this.jsonPropertyNameProcessorMap);
        return jsonConfig;
    }
}

