/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.core.lang.reflect.ConstructorUtil;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.ezmorph.Morpher;
import com.feilong.lib.ezmorph.array.ObjectArrayMorpher;
import com.feilong.lib.ezmorph.bean.BeanMorpher;
import com.feilong.lib.ezmorph.object.IdentityObjectMorpher;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONArrayToBeanUtil;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.PropertyValueConvertUtil;
import com.feilong.lib.json.PropertyValueMorpher;
import com.feilong.lib.json.processors.PropertyNameProcessor;
import com.feilong.lib.json.util.ClassResolver;
import com.feilong.lib.json.util.JSONExceptionUtil;
import com.feilong.lib.json.util.JSONUtils;
import com.feilong.lib.json.util.KeyUpdate;
import com.feilong.lib.json.util.PropertyFilter;
import com.feilong.lib.json.util.PropertySetStrategy;
import com.feilong.lib.json.util.TargetClassFinder;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.DynaBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONObjectToBeanUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONObjectToBeanUtil.class);

    private JSONObjectToBeanUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        DynaBean dynaBean = null;
        JsonConfig jsonConfig = new JsonConfig();
        Map<String, Class<?>> props = JSONUtils.getProperties(jsonObject);
        dynaBean = JSONUtils.newDynaBean(jsonObject, jsonConfig);
        Iterator entries = jsonObject.names(jsonConfig).iterator();
        while (entries.hasNext()) {
            String name = (String)entries.next();
            String key = JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            Class<?> type = props.get(name);
            Object value = jsonObject.get(name);
            try {
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        dynaBean.set(key, JSONArrayToBeanUtil.toCollection((JSONArray)value));
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                        dynaBean.set(key, value);
                        continue;
                    }
                    dynaBean.set(key, JSONObjectToBeanUtil.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    LOGGER.warn("Tried to assign null value to {}:{}", (Object)key, (Object)type.getName());
                    dynaBean.set(key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                dynaBean.set(key, null);
            }
            catch (Exception e) {
                throw JSONExceptionUtil.build("Error while setting property=" + name + " type" + type, e);
            }
        }
        return dynaBean;
    }

    public static Object toBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        Class<?> beanClass = jsonConfig.getRootClass();
        if (beanClass == null) {
            return JSONObjectToBeanUtil.toBean(jsonObject);
        }
        Map<String, Class<Object>> classMap = jsonConfig.getClassMap();
        if (classMap == null) {
            classMap = Collections.emptyMap();
        }
        HashMap bean = null;
        try {
            if (beanClass.isInterface()) {
                if (!Map.class.isAssignableFrom(beanClass)) {
                    throw new JSONException("beanClass is an interface. " + beanClass);
                }
                bean = new HashMap();
            } else {
                bean = (HashMap)ConstructorUtil.newInstance(beanClass, new Object[0]);
            }
        }
        catch (Exception e) {
            throw JSONExceptionUtil.build("", e);
        }
        Map<String, Class<?>> properties = JSONUtils.getProperties(jsonObject);
        PropertyFilter javaPropertyFilter = jsonConfig.getJavaPropertyFilter();
        Iterator entries = jsonObject.names(jsonConfig).iterator();
        while (entries.hasNext()) {
            String name = (String)entries.next();
            Object value = jsonObject.get(name);
            if (javaPropertyFilter != null && javaPropertyFilter.apply(bean, name, value)) continue;
            String key = JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            PropertyNameProcessor propertyNameProcessor = jsonConfig.findJavaPropertyNameProcessor(beanClass);
            key = KeyUpdate.update(beanClass, key, propertyNameProcessor);
            Class<?> type = properties.get(name);
            try {
                if (Map.class.isAssignableFrom(beanClass)) {
                    JSONObjectToBeanUtil.toBeanDoWithMap(jsonConfig, classMap, bean, name, type, value, key);
                    continue;
                }
                PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(bean, key);
                if (propertyDescriptor != null && propertyDescriptor.getWriteMethod() == null) {
                    LOGGER.debug("Property '{}' of {} has no write method. SKIPPED.", (Object)key, bean.getClass());
                    continue;
                }
                JSONObjectToBeanUtil.toBeanDoWithBean(bean, name, type, value, key, jsonConfig, classMap, propertyDescriptor);
            }
            catch (Exception e) {
                throw JSONExceptionUtil.build("Error while setting property=" + name + " type" + type, e);
            }
        }
        return bean;
    }

    private static void toBeanDoWithBean(Object bean, String name, Class<?> type, Object value, String key, JsonConfig jsonConfig, Map<String, Class<?>> classMap, PropertyDescriptor propertyDescriptor) throws Exception {
        Class<?> beanClass = bean.getClass();
        if (propertyDescriptor != null) {
            Class<?> propertyType;
            if (JSONUtils.isNull(value)) {
                JSONObjectToBeanUtil.setNull(jsonConfig, bean, type, key);
                return;
            }
            Class<?> targetType = propertyType = propertyDescriptor.getPropertyType();
            if (value instanceof JSONArray) {
                if (List.class.isAssignableFrom(propertyType) || Set.class.isAssignableFrom(propertyType)) {
                    JSONObjectToBeanUtil.setProperty(bean, key, PropertyValueConvertUtil.toCollection(key, value, jsonConfig, name, classMap, propertyType), jsonConfig);
                } else {
                    JSONObjectToBeanUtil.setProperty(bean, key, PropertyValueConvertUtil.toArray(key, value, targetType, jsonConfig, classMap), jsonConfig);
                }
                return;
            }
            if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (!targetType.isInstance(value)) {
                    JSONObjectToBeanUtil.setProperty(bean, key, PropertyValueMorpher.morphPropertyValue(key, value, type, targetType), jsonConfig);
                } else {
                    JSONObjectToBeanUtil.setProperty(bean, key, value, jsonConfig);
                }
                return;
            }
            if (targetType == Object.class || targetType.isInterface()) {
                Class<?> targetTypeCopy = targetType;
                targetType = TargetClassFinder.findTargetClass(key, classMap);
                targetType = targetType == null ? TargetClassFinder.findTargetClass(name, classMap) : targetType;
                targetType = targetType == null && targetTypeCopy.isInterface() ? targetTypeCopy : targetType;
            }
            JsonConfig jsonConfigCopy = jsonConfig.copy();
            jsonConfigCopy.setRootClass(targetType);
            jsonConfigCopy.setClassMap(classMap);
            JSONObjectToBeanUtil.setProperty(bean, key, JSONObjectToBeanUtil.toBean((JSONObject)value, jsonConfigCopy), jsonConfig);
            return;
        }
        if (!JSONUtils.isNull(value)) {
            if (value instanceof JSONArray) {
                JSONObjectToBeanUtil.setProperty(bean, key, PropertyValueConvertUtil.toCollection(key, value, jsonConfig, name, classMap, List.class), jsonConfig);
                return;
            }
            if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (beanClass == null || bean instanceof Map) {
                    JSONObjectToBeanUtil.setProperty(bean, key, value, jsonConfig);
                } else {
                    LOGGER.info("skip set [{}] property [{}]:[{}]", new Object[]{bean.getClass().getName(), key, type.getName()});
                }
                return;
            }
            JSONObjectToBeanUtil.setProperty(bean, key, value, jsonConfig);
            return;
        }
        JSONObjectToBeanUtil.setNull(jsonConfig, bean, type, key);
    }

    private static void setNull(JsonConfig jsonConfig, Object bean, Class<?> type, String key) throws Exception {
        if (type.isPrimitive()) {
            LOGGER.warn("Tried to assign null value to {}:{}", (Object)key, (Object)type.getName());
            JSONObjectToBeanUtil.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
        } else {
            JSONObjectToBeanUtil.setProperty(bean, key, null, jsonConfig);
        }
    }

    private static void toBeanDoWithMap(JsonConfig jsonConfig, Map<String, Class<?>> classMap, Object bean, String name, Class<?> type, Object value, String key) throws Exception {
        if (JSONUtils.isNull(value)) {
            JSONObjectToBeanUtil.setProperty(bean, key, value, jsonConfig);
            return;
        }
        if (value instanceof JSONArray) {
            JSONObjectToBeanUtil.setProperty(bean, key, PropertyValueConvertUtil.toCollection(key, value, jsonConfig, name, classMap, List.class), jsonConfig);
            return;
        }
        if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
            JSONObjectToBeanUtil.setProperty(bean, key, value, jsonConfig);
            return;
        }
        Class<?> targetClass = ClassResolver.resolveClass(classMap, key, name, type);
        JsonConfig jsonConfigCopy = jsonConfig.copy();
        jsonConfigCopy.setRootClass(targetClass);
        jsonConfigCopy.setClassMap(classMap);
        if (targetClass != null) {
            JSONObjectToBeanUtil.setProperty(bean, key, JSONObjectToBeanUtil.toBean((JSONObject)value, jsonConfigCopy), jsonConfig);
        } else {
            JSONObjectToBeanUtil.setProperty(bean, key, JSONObjectToBeanUtil.toBean((JSONObject)value), jsonConfig);
        }
    }

    public static Object toBean(JSONObject jsonObject, Object root, JsonConfig jsonConfig) {
        if (jsonObject == null || jsonObject.isNullObject() || root == null) {
            return root;
        }
        Class<?> rootClass = root.getClass();
        if (rootClass.isInterface()) {
            throw new JSONException("Root bean is an interface. " + rootClass);
        }
        Map<String, Class<Object>> classMap = jsonConfig.getClassMap();
        if (classMap == null) {
            classMap = Collections.emptyMap();
        }
        Map<String, Class<?>> props = JSONUtils.getProperties(jsonObject);
        PropertyFilter javaPropertyFilter = jsonConfig.getJavaPropertyFilter();
        Iterator entries = jsonObject.names(jsonConfig).iterator();
        while (entries.hasNext()) {
            String name = (String)entries.next();
            Class<?> type = props.get(name);
            Object value = jsonObject.get(name);
            if (javaPropertyFilter != null && javaPropertyFilter.apply(root, name, value)) continue;
            String key = JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(root, key);
                if (pd != null && pd.getWriteMethod() == null) {
                    LOGGER.info("Property '{}' of {} has no write method. SKIPPED.", (Object)key, root.getClass());
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    Object newRoot;
                    Class<Object> targetClass;
                    if (value instanceof JSONArray) {
                        if (pd == null || List.class.isAssignableFrom(pd.getPropertyType())) {
                            targetClass = ClassResolver.resolveClass(classMap, key, name, type);
                            newRoot = ConstructorUtil.newInstance(targetClass, new Object[0]);
                            List list = JSONArrayToBeanUtil.toList((JSONArray)value, newRoot, jsonConfig);
                            JSONObjectToBeanUtil.setProperty(root, key, list, jsonConfig);
                            continue;
                        }
                        Class<?> innerType = JSONUtils.getInnerComponentType(pd.getPropertyType());
                        Class<?> targetInnerType = TargetClassFinder.findTargetClass(key, classMap);
                        if (innerType.equals(Object.class) && targetInnerType != null && !targetInnerType.equals(Object.class)) {
                            innerType = targetInnerType;
                        }
                        Object newRoot2 = ConstructorUtil.newInstance(innerType, new Object[0]);
                        Object array = JSONArrayToBeanUtil.toArray((JSONArray)value, newRoot2, jsonConfig);
                        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType)) {
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        } else if (!array.getClass().equals(pd.getPropertyType()) && !pd.getPropertyType().equals(Object.class)) {
                            Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(Array.newInstance(innerType, 0).getClass());
                            if (IdentityObjectMorpher.INSTANCE.equals(morpher)) {
                                ObjectArrayMorpher beanMorpher = new ObjectArrayMorpher(new BeanMorpher(innerType, JSONUtils.getMorpherRegistry()));
                                JSONUtils.getMorpherRegistry().registerMorpher(beanMorpher);
                            }
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        }
                        JSONObjectToBeanUtil.setProperty(root, key, array, jsonConfig);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (pd != null) {
                            if (!pd.getPropertyType().isInstance(value)) {
                                Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(pd.getPropertyType());
                                if (IdentityObjectMorpher.INSTANCE.equals(morpher)) {
                                    LOGGER.warn("Can't transform property '{}' from {} into {}. Will register a default BeanMorpher", new Object[]{key, type.getName(), pd.getPropertyType().getName()});
                                    JSONUtils.getMorpherRegistry().registerMorpher(new BeanMorpher(pd.getPropertyType(), JSONUtils.getMorpherRegistry()));
                                }
                                JSONObjectToBeanUtil.setProperty(root, key, JSONUtils.getMorpherRegistry().morph(pd.getPropertyType(), value), jsonConfig);
                                continue;
                            }
                            JSONObjectToBeanUtil.setProperty(root, key, value, jsonConfig);
                            continue;
                        }
                        if (root instanceof Map) {
                            JSONObjectToBeanUtil.setProperty(root, key, value, jsonConfig);
                            continue;
                        }
                        LOGGER.warn("Tried to assign property {}:{} to bean of class {}", new Object[]{key, type.getName(), root.getClass().getName()});
                        continue;
                    }
                    if (pd != null) {
                        targetClass = pd.getPropertyType();
                        if (targetClass == Object.class && (targetClass = ClassResolver.resolveClass(classMap, key, name, type)) == null) {
                            targetClass = Object.class;
                        }
                        newRoot = ConstructorUtil.newInstance(targetClass, new Object[0]);
                        JSONObjectToBeanUtil.setProperty(root, key, JSONObjectToBeanUtil.toBean((JSONObject)value, newRoot, jsonConfig), jsonConfig);
                        continue;
                    }
                    if (root instanceof Map) {
                        targetClass = TargetClassFinder.findTargetClass(key, classMap);
                        targetClass = targetClass == null ? TargetClassFinder.findTargetClass(name, classMap) : targetClass;
                        newRoot = ConstructorUtil.newInstance(targetClass, new Object[0]);
                        JSONObjectToBeanUtil.setProperty(root, key, JSONObjectToBeanUtil.toBean((JSONObject)value, newRoot, jsonConfig), jsonConfig);
                        continue;
                    }
                    LOGGER.warn("Tried to assign property {}:{} to bean of class {}", new Object[]{key, type.getName(), rootClass.getName()});
                    continue;
                }
                if (type.isPrimitive()) {
                    LOGGER.warn("Tried to assign null value to {}:{}", (Object)key, (Object)type.getName());
                    JSONObjectToBeanUtil.setProperty(root, key, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
                    continue;
                }
                JSONObjectToBeanUtil.setProperty(root, key, null, jsonConfig);
            }
            catch (Exception e) {
                throw JSONExceptionUtil.build("Error while setting property=" + name + " type " + type, e);
            }
        }
        return root;
    }

    private static void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) throws Exception {
        PropertySetStrategy propertySetStrategy = PropertySetStrategy.DEFAULT;
        propertySetStrategy.setProperty(bean, key, value, jsonConfig);
    }
}

