/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.core.lang.reflect.ConstructorUtil;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.JSONExceptionUtil;
import com.feilong.lib.json.util.JSONUtils;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONArrayToBeanUtil {
    private JSONArrayToBeanUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Collection toCollection(JSONArray jsonArray, JsonConfig jsonConfig) {
        AbstractCollection collection = null;
        Class<?> collectionType = jsonConfig.getCollectionType();
        if (collectionType.isInterface()) {
            if (collectionType.equals(List.class)) {
                collection = new ArrayList();
            } else {
                if (!collectionType.equals(Set.class)) throw new JSONException("unknown interface: " + collectionType);
                collection = new HashSet();
            }
        } else {
            try {
                collection = (ArrayList)collectionType.newInstance();
            }
            catch (InstantiationException e) {
                throw new JSONException(e);
            }
            catch (IllegalAccessException e) {
                throw new JSONException(e);
            }
        }
        Class<?> objectClass = jsonConfig.getRootClass();
        Map<String, Class<?>> classMap = jsonConfig.getClassMap();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                collection.add(null);
                continue;
            }
            Class<?> type = value.getClass();
            if (JSONArray.class.isAssignableFrom(value.getClass())) {
                collection.add(JSONArrayToBeanUtil.toCollection((JSONArray)value, jsonConfig));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value = JSONUtils.getMorpherRegistry().morph(objectClass, value);
                }
                collection.add(value);
                continue;
            }
            if (objectClass != null) {
                JsonConfig jsc = jsonConfig.copy();
                jsc.setRootClass(objectClass);
                jsc.setClassMap(classMap);
                collection.add(JSONObject.toBean((JSONObject)value, jsc));
                continue;
            }
            collection.add(JSONObject.toBean((JSONObject)value));
        }
        return collection;
    }

    static List toList(JSONArray jsonArray, Object root, JsonConfig jsonConfig) {
        if (jsonArray.size() == 0 || root == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                list.add(null);
                continue;
            }
            Class<?> type = value.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                list.add(JSONArrayToBeanUtil.toList((JSONArray)value, root, jsonConfig));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                list.add(value);
                continue;
            }
            try {
                Object newRoot = ConstructorUtil.newInstance(root.getClass(), new Object[0]);
                list.add(JSONObject.toBean((JSONObject)value, newRoot, jsonConfig));
                continue;
            }
            catch (Exception e) {
                throw JSONExceptionUtil.build("", e);
            }
        }
        return list;
    }

    static Object toArray(JSONArray jsonArray, Object root, JsonConfig jsonConfig) {
        Class<?> objectClass = root.getClass();
        if (jsonArray.size() == 0) {
            return Array.newInstance(objectClass, 0);
        }
        int[] dimensions = JSONArrayToBeanUtil.getDimensions(jsonArray);
        Object array = Array.newInstance(objectClass == null ? Object.class : objectClass, dimensions);
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                Array.set(array, i, null);
                continue;
            }
            Class<?> type = value.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                Array.set(array, i, JSONArrayToBeanUtil.toArray((JSONArray)value, root, jsonConfig));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value = JSONUtils.getMorpherRegistry().morph(objectClass, value);
                }
                Array.set(array, i, value);
                continue;
            }
            try {
                Object newRoot = ConstructorUtil.newInstance(root.getClass(), new Object[0]);
                Array.set(array, i, JSONObject.toBean((JSONObject)value, newRoot, jsonConfig));
                continue;
            }
            catch (Exception e) {
                throw JSONExceptionUtil.build("", e);
            }
        }
        return array;
    }

    public static Collection toCollection(JSONArray jsonArray) {
        return JSONArrayToBeanUtil.toCollection(jsonArray, new JsonConfig());
    }

    static Object toArray(JSONArray jsonArray, JsonConfig jsonConfig) {
        Class<?> objectClass = jsonConfig.getRootClass();
        Map<String, Class<?>> classMap = jsonConfig.getClassMap();
        if (jsonArray.size() == 0) {
            return Array.newInstance(objectClass == null ? Object.class : objectClass, 0);
        }
        int[] dimensions = JSONArrayToBeanUtil.getDimensions(jsonArray);
        Object array = Array.newInstance(objectClass == null ? Object.class : objectClass, dimensions);
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (JSONUtils.isNull(value)) {
                Array.set(array, i, null);
                continue;
            }
            Class<?> type = value.getClass();
            if (JSONArray.class.isAssignableFrom(type)) {
                Array.set(array, i, JSONArrayToBeanUtil.toArray((JSONArray)value, objectClass, classMap));
                continue;
            }
            if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                if (objectClass != null && !objectClass.isAssignableFrom(type)) {
                    value = JSONUtils.getMorpherRegistry().morph(objectClass, value);
                }
                Array.set(array, i, value);
                continue;
            }
            if (JSONUtils.isNumber(type)) {
                if (objectClass != null && (Byte.class.isAssignableFrom(objectClass) || Byte.TYPE.isAssignableFrom(objectClass))) {
                    Array.set(array, i, Byte.valueOf(String.valueOf(value)));
                    continue;
                }
                if (objectClass != null && (Short.class.isAssignableFrom(objectClass) || Short.TYPE.isAssignableFrom(objectClass))) {
                    Array.set(array, i, Short.valueOf(String.valueOf(value)));
                    continue;
                }
                Array.set(array, i, value);
                continue;
            }
            if (objectClass != null) {
                JsonConfig jsc = jsonConfig.copy();
                jsc.setRootClass(objectClass);
                jsc.setClassMap(classMap);
                Array.set(array, i, JSONObject.toBean((JSONObject)value, jsc));
                continue;
            }
            Array.set(array, i, JSONObject.toBean((JSONObject)value));
        }
        return array;
    }

    private static Object toArray(JSONArray jsonArray, Class<?> objectClass, Map<String, Class<?>> classMap) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(objectClass);
        jsonConfig.setClassMap(classMap);
        return JSONArrayToBeanUtil.toArray(jsonArray, jsonConfig);
    }

    static int[] getDimensions(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return new int[]{0};
        }
        ArrayList dims = new ArrayList();
        JSONArrayToBeanUtil.processArrayDimensions(jsonArray, dims, 0);
        int[] dimensions = new int[dims.size()];
        int j = 0;
        Iterator i = dims.iterator();
        while (i.hasNext()) {
            dimensions[j++] = (Integer)i.next();
        }
        return dimensions;
    }

    private static void processArrayDimensions(JSONArray jsonArray, List dims, int index) {
        if (dims.size() <= index) {
            dims.add(jsonArray.size());
        } else {
            int i = (Integer)dims.get(index);
            if (jsonArray.size() > i) {
                dims.set(index, jsonArray.size());
            }
        }
        Iterator i = jsonArray.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (!(item instanceof JSONArray)) continue;
            JSONArrayToBeanUtil.processArrayDimensions((JSONArray)item, dims, index + 1);
        }
    }
}

