/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.primitive;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class FloatMorpher
extends AbstractPrimitiveMorpher<Float> {
    public FloatMorpher() {
    }

    public FloatMorpher(float defaultValue) {
        super(true);
        this.defaultValue = Float.valueOf(defaultValue);
    }

    public float morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return ((Float)this.defaultValue).floatValue();
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        try {
            return Float.parseFloat(String.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return ((Float)this.defaultValue).floatValue();
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class<?> morphsTo() {
        return Float.TYPE;
    }
}

