/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.primitive;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class BooleanMorpher
extends AbstractPrimitiveMorpher<Boolean> {
    public BooleanMorpher() {
    }

    public BooleanMorpher(boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return (Boolean)this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            if (value instanceof Double && (Double.isInfinite(((Number)value).doubleValue()) || Double.isNaN(((Number)value).doubleValue()))) {
                return true;
            }
            if (value instanceof Float && (Float.isInfinite(((Number)value).floatValue()) || Float.isNaN(((Number)value).floatValue()))) {
                return true;
            }
            long l = ((Number)value).longValue();
            return l != 0L;
        }
        String s = String.valueOf(value);
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off")) {
            return false;
        }
        if (this.isUseDefault()) {
            return (Boolean)this.defaultValue;
        }
        throw new MorphException("Can't morph value: " + value);
    }

    @Override
    public Class<?> morphsTo() {
        return Boolean.TYPE;
    }
}

