/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.object;

import com.feilong.lib.ezmorph.ObjectMorpher;

public class EnumMorpher
implements ObjectMorpher {
    private final Class<?> enumClass;

    public EnumMorpher(Class<?> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("enumClass is null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("enumClass is not an Enum class");
        }
        this.enumClass = enumClass;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            return this.enumClass.cast(null);
        }
        return Enum.valueOf(this.enumClass, String.valueOf(value));
    }

    @Override
    public Class<?> morphsTo() {
        return this.enumClass;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }
}

