/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.object;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.object.AbstractObjectMorpher;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigDecimalMorpher
extends AbstractObjectMorpher<BigDecimal> {
    public BigDecimalMorpher() {
    }

    public BigDecimalMorpher(BigDecimal defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object morph(Object value) {
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isInfinite() || f.isNaN()) {
                    throw new MorphException("BigDecimal can not be infinite or NaN");
                }
            } else if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isInfinite() || d.isNaN()) {
                    throw new MorphException("BigDecimal can not be infinite or NaN");
                }
            } else if (value instanceof BigInteger) {
                return ConvertUtil.toBigDecimal(value);
            }
            return ConvertUtil.toBigDecimal(value).doubleValue();
        }
        try {
            String str = String.valueOf(value).trim();
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            return ConvertUtil.toBigDecimal(str);
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class<?> morphsTo() {
        return BigDecimal.class;
    }
}

