/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.bean;

import com.feilong.lib.beanutils.DynaClass;
import com.feilong.lib.beanutils.DynaProperty;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.MorphUtils;
import com.feilong.lib.ezmorph.MorpherRegistry;
import com.feilong.lib.ezmorph.bean.MorphDynaBean;
import com.feilong.lib.lang3.builder.EqualsBuilder;
import com.feilong.lib.lang3.builder.HashCodeBuilder;
import com.feilong.lib.lang3.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;

public final class MorphDynaClass
implements DynaClass,
Serializable {
    private static final Comparator dynaPropertyComparator = new Comparator(){

        public int compare(Object a, Object b) {
            if (a instanceof DynaProperty && b instanceof DynaProperty) {
                DynaProperty p1 = (DynaProperty)a;
                DynaProperty p2 = (DynaProperty)b;
                return p1.getName().compareTo(p2.getName());
            }
            return -1;
        }
    };
    private static final long serialVersionUID = -613214016860871560L;
    private final Map attributes;
    private Class<?> beanClass;
    private DynaProperty[] dynaProperties;
    private final String name;
    private final Map properties = new HashMap();
    private final Class<?> type;

    public MorphDynaClass(Map attributes) {
        this(null, null, attributes);
    }

    public MorphDynaClass(Map attributes, boolean exceptionOnEmptyAttributes) {
        this(null, null, attributes, exceptionOnEmptyAttributes);
    }

    public MorphDynaClass(String name, Class<?> type, Map attributes) {
        this(name, type, attributes, false);
    }

    public MorphDynaClass(String name, Class<?> type, Map attributes, boolean exceptionOnEmptyAttributes) {
        if (name == null) {
            name = "MorphDynaClass";
        }
        if (type == null) {
            type = MorphDynaBean.class;
        }
        if (!MorphDynaBean.class.isAssignableFrom(type)) {
            throw new MorphException("MorphDynaBean is not assignable from " + type.getName());
        }
        if (attributes == null || attributes.isEmpty()) {
            if (exceptionOnEmptyAttributes) {
                throw new MorphException("Attributes map is null or empty.");
            }
            attributes = new HashMap();
        }
        this.name = name;
        this.type = type;
        this.attributes = attributes;
        this.process();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MorphDynaClass)) {
            return false;
        }
        MorphDynaClass other = (MorphDynaClass)obj;
        EqualsBuilder builder = new EqualsBuilder().append(this.name, other.name).append(this.type, other.type);
        if (this.dynaProperties.length != other.dynaProperties.length) {
            return false;
        }
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            DynaProperty a = this.dynaProperties[i];
            DynaProperty b = other.dynaProperties[i];
            builder.append(a.getName(), b.getName());
            builder.append(a.getType(), b.getType());
        }
        return builder.isEquals();
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return this.dynaProperties;
    }

    @Override
    public DynaProperty getDynaProperty(String propertyName) {
        if (propertyName == null) {
            throw new MorphException("Unnespecified bean property name");
        }
        return (DynaProperty)this.properties.get(propertyName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append(this.name).append(this.type);
        for (int i = 0; i < this.dynaProperties.length; ++i) {
            builder.append(this.dynaProperties[i].getName());
            builder.append(this.dynaProperties[i].getType());
        }
        return builder.toHashCode();
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        MorpherRegistry morpherRegistry = new MorpherRegistry();
        MorphUtils.registerStandardMorphers(morpherRegistry);
        MorphDynaBean dynaBean = (MorphDynaBean)this.getBeanClass().newInstance();
        dynaBean.setDynaBeanClass(this);
        dynaBean.setMorpherRegistry(morpherRegistry);
        for (String key : this.attributes.keySet()) {
            dynaBean.set(key, null);
        }
        return dynaBean;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("type", this.type).append("attributes", this.attributes).toString();
    }

    protected Class<?> getBeanClass() {
        if (this.beanClass == null) {
            this.process();
        }
        return this.beanClass;
    }

    private void process() {
        this.beanClass = this.type;
        try {
            Iterator entries = this.attributes.entrySet().iterator();
            this.dynaProperties = new DynaProperty[this.attributes.size()];
            int i = 0;
            while (entries.hasNext()) {
                Class klass;
                Map.Entry entry = entries.next();
                String pname = (String)entry.getKey();
                Object pclass = entry.getValue();
                DynaProperty dynaProperty = null;
                if (pclass instanceof String) {
                    klass = Class.forName((String)pclass);
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new MorphException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else if (pclass instanceof Class) {
                    klass = (Class)pclass;
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new MorphException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else {
                    throw new MorphException("Type must be String or Class");
                }
                this.properties.put(dynaProperty.getName(), dynaProperty);
                this.dynaProperties[i++] = dynaProperty;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new MorphException(cnfe);
        }
        Arrays.sort(this.dynaProperties, 0, this.dynaProperties.length, dynaPropertyComparator);
    }
}

