/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.LongMorpher;
import java.lang.reflect.Array;

public final class LongArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> LONG_ARRAY_CLASS = long[].class;
    private long defaultValue;

    public LongArrayMorpher() {
        super(false);
    }

    public LongArrayMorpher(long defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (LONG_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            LongMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = LongArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Long.TYPE, dimensions);
            LongMorpher longMorpher = morpher = this.isUseDefault() ? new LongMorpher(this.defaultValue) : new LongMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return LONG_ARRAY_CLASS;
    }
}

