/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.IntMorpher;
import java.lang.reflect.Array;

public final class IntArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> INT_ARRAY_CLASS = int[].class;
    private int defaultValue;

    public IntArrayMorpher() {
        super(false);
    }

    public IntArrayMorpher(int defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (INT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            IntMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = IntArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Integer.TYPE, dimensions);
            IntMorpher intMorpher = morpher = this.isUseDefault() ? new IntMorpher(this.defaultValue) : new IntMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return INT_ARRAY_CLASS;
    }
}

