/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.CharMorpher;
import java.lang.reflect.Array;

public final class CharacterObjectArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> CHARACTER_OBJECT_ARRAY_CLASS = Character[].class;
    private Character defaultValue;

    public CharacterObjectArrayMorpher() {
        super(false);
    }

    public CharacterObjectArrayMorpher(Character defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public Character getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (CHARACTER_OBJECT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = CharacterObjectArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Character.class, dimensions);
            if (dims == 1) {
                CharMorpher morpher = null;
                if (this.isUseDefault()) {
                    if (this.defaultValue == null) {
                        for (int index = 0; index < length; ++index) {
                            Array.set(result, index, null);
                        }
                        return result;
                    }
                    morpher = new CharMorpher(this.defaultValue.charValue());
                } else {
                    morpher = new CharMorpher();
                }
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, Character.valueOf(morpher.morph(Array.get(array, index))));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return CHARACTER_OBJECT_ARRAY_CLASS;
    }
}

