/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.ByteMorpher;
import java.lang.reflect.Array;

public final class ByteArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> BYTE_ARRAY_CLASS = byte[].class;
    private byte defaultValue;

    public ByteArrayMorpher() {
        super(false);
    }

    public ByteArrayMorpher(byte defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public byte getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (BYTE_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            ByteMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = ByteArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Byte.TYPE, dimensions);
            ByteMorpher byteMorpher = morpher = this.isUseDefault() ? new ByteMorpher(this.defaultValue) : new ByteMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return BYTE_ARRAY_CLASS;
    }
}

