/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.BooleanMorpher;
import java.lang.reflect.Array;

public final class BooleanArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> BOOLEAN_ARRAY_CLASS = boolean[].class;
    private boolean defaultValue;

    public BooleanArrayMorpher() {
        super(false);
    }

    public BooleanArrayMorpher(boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (BOOLEAN_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            BooleanMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = BooleanArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Boolean.TYPE, dimensions);
            BooleanMorpher booleanMorpher = morpher = this.isUseDefault() ? new BooleanMorpher(this.defaultValue) : new BooleanMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, morpher.morph(Array.get(array, index)) ? Boolean.TRUE : Boolean.FALSE);
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return BOOLEAN_ARRAY_CLASS;
    }
}

