/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.Morpher;
import com.feilong.lib.ezmorph.ObjectMorpher;
import com.feilong.lib.ezmorph.object.IdentityObjectMorpher;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MorpherRegistry
implements Serializable {
    private static final long serialVersionUID = -3894767123320768419L;
    private final Map<Class<?>, List<Morpher>> morpherMap = new HashMap();

    public synchronized void clear() {
        this.morpherMap.clear();
    }

    public synchronized Morpher getMorpherFor(Class<?> clazz) {
        List<Morpher> registered = this.morpherMap.get(clazz);
        if (registered == null || registered.isEmpty()) {
            return IdentityObjectMorpher.INSTANCE;
        }
        return registered.get(0);
    }

    private synchronized Morpher[] getMorphersFor(Class<?> clazz) {
        List<Morpher> registered = this.morpherMap.get(clazz);
        if (registered == null || registered.isEmpty()) {
            return new Morpher[]{IdentityObjectMorpher.INSTANCE};
        }
        Morpher[] morphs = new Morpher[registered.size()];
        int k = 0;
        Iterator<Morpher> i = registered.iterator();
        while (i.hasNext()) {
            morphs[k++] = i.next();
        }
        return morphs;
    }

    public Object morph(Class<?> target, Object value) {
        if (value == null) {
            Morpher morpher = this.getMorpherFor(target);
            if (morpher instanceof ObjectMorpher) {
                return ((ObjectMorpher)morpher).morph(value);
            }
            try {
                Method morphMethod = morpher.getClass().getDeclaredMethod("morph", Object.class);
                return morphMethod.invoke((Object)morpher, value);
            }
            catch (Exception e) {
                throw new MorphException(e);
            }
        }
        Morpher[] morphers = this.getMorphersFor(target);
        for (int i = 0; i < morphers.length; ++i) {
            Morpher morpher = morphers[i];
            if (!morpher.supports(value.getClass())) continue;
            if (morpher instanceof ObjectMorpher) {
                return ((ObjectMorpher)morpher).morph(value);
            }
            try {
                Method morphMethod = morpher.getClass().getDeclaredMethod("morph", Object.class);
                return morphMethod.invoke((Object)morpher, value);
            }
            catch (Exception e) {
                throw new MorphException(e);
            }
        }
        return value;
    }

    public void registerMorpher(Morpher morpher) {
        Class<?> klass = morpher.morphsTo();
        List<Morpher> registered = this.morpherMap.get(klass);
        if (registered == null) {
            registered = new ArrayList<Morpher>();
            this.morpherMap.put(klass, registered);
        }
        if (!registered.contains(morpher)) {
            registered.add(morpher);
        }
    }
}

