/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph;

import com.feilong.lib.ezmorph.MorpherRegistry;
import com.feilong.lib.ezmorph.array.BooleanArrayMorpher;
import com.feilong.lib.ezmorph.array.ByteArrayMorpher;
import com.feilong.lib.ezmorph.array.CharArrayMorpher;
import com.feilong.lib.ezmorph.array.DoubleArrayMorpher;
import com.feilong.lib.ezmorph.array.FloatArrayMorpher;
import com.feilong.lib.ezmorph.array.IntArrayMorpher;
import com.feilong.lib.ezmorph.array.LongArrayMorpher;
import com.feilong.lib.ezmorph.array.ObjectArrayMorpher;
import com.feilong.lib.ezmorph.array.ShortArrayMorpher;
import com.feilong.lib.ezmorph.object.BooleanObjectMorpher;
import com.feilong.lib.ezmorph.object.CharacterObjectMorpher;
import com.feilong.lib.ezmorph.object.ClassMorpher;
import com.feilong.lib.ezmorph.object.NumberMorpher;
import com.feilong.lib.ezmorph.object.StringMorpher;
import com.feilong.lib.ezmorph.primitive.BooleanMorpher;
import com.feilong.lib.ezmorph.primitive.ByteMorpher;
import com.feilong.lib.ezmorph.primitive.CharMorpher;
import com.feilong.lib.ezmorph.primitive.DoubleMorpher;
import com.feilong.lib.ezmorph.primitive.FloatMorpher;
import com.feilong.lib.ezmorph.primitive.IntMorpher;
import com.feilong.lib.ezmorph.primitive.LongMorpher;
import com.feilong.lib.ezmorph.primitive.ShortMorpher;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MorphUtils {
    private MorphUtils() {
    }

    public static void registerStandardMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.clear();
        MorphUtils.registerStandardPrimitiveMorphers(morpherRegistry);
        MorphUtils.registerStandardPrimitiveArrayMorphers(morpherRegistry);
        MorphUtils.registerStandardObjectMorphers(morpherRegistry);
        MorphUtils.registerStandardObjectArrayMorphers(morpherRegistry);
    }

    private static void registerStandardObjectArrayMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new BooleanObjectMorpher((Boolean)false)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new CharacterObjectMorpher(Character.valueOf('\u0000'))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(StringMorpher.INSTANCE));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Byte.class, (byte)0)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Short.class, (short)0)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Integer.class, 0)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Long.class, 0L)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Float.class, Float.valueOf(0.0f))));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(Double.class, 0.0)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(BigInteger.class, BigInteger.ZERO)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(new NumberMorpher(BigDecimal.class, BigDecimal.ZERO)));
        morpherRegistry.registerMorpher(new ObjectArrayMorpher(ClassMorpher.INSTANCE));
    }

    private static void registerStandardObjectMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanObjectMorpher(Boolean.FALSE));
        morpherRegistry.registerMorpher(new CharacterObjectMorpher(Character.valueOf('\u0000')));
        morpherRegistry.registerMorpher(StringMorpher.INSTANCE);
        morpherRegistry.registerMorpher(new NumberMorpher(Byte.class, (byte)0));
        morpherRegistry.registerMorpher(new NumberMorpher(Short.class, (short)0));
        morpherRegistry.registerMorpher(new NumberMorpher(Integer.class, 0));
        morpherRegistry.registerMorpher(new NumberMorpher(Long.class, 0L));
        morpherRegistry.registerMorpher(new NumberMorpher(Float.class, Float.valueOf(0.0f)));
        morpherRegistry.registerMorpher(new NumberMorpher(Double.class, 0.0));
        morpherRegistry.registerMorpher(new NumberMorpher(BigInteger.class, BigInteger.ZERO));
        morpherRegistry.registerMorpher(new NumberMorpher(BigDecimal.class, BigDecimal.ZERO));
        morpherRegistry.registerMorpher(ClassMorpher.INSTANCE);
    }

    private static void registerStandardPrimitiveArrayMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanArrayMorpher(false));
        morpherRegistry.registerMorpher(new CharArrayMorpher('\u0000'));
        morpherRegistry.registerMorpher(new ByteArrayMorpher(0));
        morpherRegistry.registerMorpher(new ShortArrayMorpher(0));
        morpherRegistry.registerMorpher(new IntArrayMorpher(0));
        morpherRegistry.registerMorpher(new LongArrayMorpher(0L));
        morpherRegistry.registerMorpher(new FloatArrayMorpher(0.0f));
        morpherRegistry.registerMorpher(new DoubleArrayMorpher(0.0));
    }

    private static void registerStandardPrimitiveMorphers(MorpherRegistry morpherRegistry) {
        morpherRegistry.registerMorpher(new BooleanMorpher(false));
        morpherRegistry.registerMorpher(new CharMorpher('\u0000'));
        morpherRegistry.registerMorpher(new ByteMorpher(0));
        morpherRegistry.registerMorpher(new ShortMorpher(0));
        morpherRegistry.registerMorpher(new IntMorpher(0));
        morpherRegistry.registerMorpher(new LongMorpher(0L));
        morpherRegistry.registerMorpher(new FloatMorpher(0.0f));
        morpherRegistry.registerMorpher(new DoubleMorpher(0.0));
    }
}

