/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.ognl;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.lib.excel.ognl.OgnlContextBuilder;
import com.feilong.lib.excel.ognl.OgnlUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;

public class OgnlStack {
    private final List<Object> stackList = new ArrayList<Object>();
    private final Map<String, Object> context;
    private final Map<String, Object> expressions = new HashMap<String, Object>();

    public OgnlStack(Object obj) {
        OgnlUtil.setNullHandler();
        this.stackList.add(obj);
        this.context = ConvertUtil.toMap("loxia.useingLoxiaNullHandler", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getExpression(String expr) throws OgnlException {
        Map<String, Object> map = this.expressions;
        synchronized (map) {
            Object object = this.expressions.get(expr);
            if (object == null) {
                object = Ognl.parseExpression((String)expr);
                this.expressions.put(expr, object);
            }
            return object;
        }
    }

    public Object getValue(String expr) {
        Iterator<Object> iterator = this.stackList.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            if (expr.indexOf("top") >= 0) {
                this.context.put("__top", obj);
                expr = expr.replaceAll("top", "#__top");
            }
            try {
                Object expression = this.getExpression(expr);
                return Ognl.getValue((Object)expression, (Map)OgnlContextBuilder.build(this.context), (Object)obj);
            }
            catch (Exception e) {
                throw new DefaultRuntimeException(Slf4jUtil.format("expr:[{}],obj:[{}]", expr, obj), e);
            }
        }
        return null;
    }

    public void setValue(String expr, Object value) throws OgnlException {
        Object root = this.stackList.get(0);
        Validate.notNull(root, "root can't be null!", new Object[0]);
        Ognl.setValue((Object)this.getExpression(expr), (Map)OgnlContextBuilder.build(this.context), (Object)root, (Object)value);
    }

    public void push(Object obj) {
        this.stackList.add(0, obj);
    }

    public Object pop() {
        Validate.isTrue(!this.stackList.isEmpty(), "stackList must not empty", new Object[0]);
        return this.stackList.remove(0);
    }

    public Object peek() {
        Validate.isTrue(!this.stackList.isEmpty(), "stackList must not empty", new Object[0]);
        return this.stackList.get(0);
    }

    public void addContext(String key, Object value) {
        this.context.put(key, value);
    }

    public void removeContext(String key) {
        this.context.remove(key);
    }
}

