/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.ognl;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.NullHandler;
import ognl.Ognl;
import ognl.OgnlRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantiatingNullHandler
implements NullHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstantiatingNullHandler.class);
    static final String USING_LOXIA_NULL_HANDLER = "loxia.useingLoxiaNullHandler";
    private final List<String> ignoreList = new ArrayList<String>();
    private final NullHandler handlerWrapper;

    public InstantiatingNullHandler(NullHandler nullHandler, List<String> ignoreList) {
        this.handlerWrapper = nullHandler;
        this.ignoreList.addAll(ignoreList);
    }

    public Object nullMethodResult(Map context, Object target, String methodName, Object[] args) {
        Boolean flag = (Boolean)context.get(USING_LOXIA_NULL_HANDLER);
        if (!(this.handlerWrapper == null || flag != null && flag.booleanValue())) {
            return this.handlerWrapper.nullMethodResult(context, target, methodName, args);
        }
        LOGGER.debug("Entering nullMethodResult ");
        return null;
    }

    public Object nullPropertyValue(Map context, Object target, Object property) {
        Boolean flag = (Boolean)context.get(USING_LOXIA_NULL_HANDLER);
        if (!(this.handlerWrapper == null || flag != null && flag.booleanValue())) {
            return this.handlerWrapper.nullPropertyValue(context, target, property);
        }
        LOGGER.trace("Entering nullPropertyValue [target={}, property={}]", target, property);
        if (target == null || property == null) {
            return null;
        }
        try {
            String propName = property.toString();
            Class<?> clazz = null;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(target.getClass(), (String)propName);
            if (pd == null) {
                return null;
            }
            clazz = pd.getPropertyType();
            if (clazz == null) {
                return null;
            }
            if (this.ignoreClass(clazz)) {
                return null;
            }
            Object param = InstantiatingNullHandler.createObject(clazz);
            Ognl.setValue((String)propName, (Map)context, (Object)target, (Object)param);
            return param;
        }
        catch (Exception e) {
            LOGGER.error("Could not create and/or set value back on to object", (Throwable)e);
            return null;
        }
    }

    private boolean ignoreClass(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return true;
        }
        String clazzFullName = clazz.getName();
        for (String name : this.ignoreList) {
            if (!clazzFullName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    private static Object createObject(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        if (Collection.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (clazz == Map.class) {
            return new HashMap();
        }
        return clazz.newInstance();
    }
}

