/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.lib.excel.convertor.AbstractDataConvertor;
import com.feilong.lib.lang3.BooleanUtils;

public class BooleanConvertor
extends AbstractDataConvertor<Boolean> {
    private static final int WRONG_DATA_FORMAT = 50;

    @Override
    protected Boolean handleConvert(Object value, int sheetNo, String cellIndex, ExcelCell excelCell) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            return BooleanUtils.toBooleanObject(str);
        }
        if (value instanceof Number) {
            Number value2 = (Number)value;
            return BooleanUtils.toBooleanObject(value2.intValue());
        }
        throw new ExcelException(50, sheetNo, cellIndex, value, excelCell);
    }

    @Override
    public String getDataTypeAbbr() {
        return "boolean";
    }

    @Override
    public Class<Boolean> supportClass() {
        return Boolean.class;
    }
}

