/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.lib.excel.convertor.AbstractDataConvertor;
import java.math.BigDecimal;

public class BigDecimalConvertor
extends AbstractDataConvertor<BigDecimal> {
    @Override
    protected BigDecimal handleConvert(Object value, int sheetNo, String cellIndex, ExcelCell excelCell) {
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() == 0) {
                if (!excelCell.isMandatory()) {
                    return null;
                }
                throw new ExcelException(1, sheetNo, cellIndex, null, excelCell);
            }
            try {
                return ConvertUtil.toBigDecimal(value);
            }
            catch (Exception e) {
                throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
            }
        }
        if (value instanceof Double) {
            return ConvertUtil.toBigDecimal(value);
        }
        throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
    }

    @Override
    public String getDataTypeAbbr() {
        return "bigdecimal";
    }

    @Override
    public Class<BigDecimal> supportClass() {
        return BigDecimal.class;
    }
}

