/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.lib.excel.convertor.AbstractDataConvertor;
import com.feilong.lib.lang3.ArrayUtils;

public abstract class AbstractChoiceConvertor<T>
extends AbstractDataConvertor<T> {
    private static final int OUT_OF_CHOICES = 3;

    @Override
    protected T handleConvert(Object value, int sheetNo, String cellIndex, ExcelCell excelCell) {
        T t = this.convertValue(sheetNo, cellIndex, excelCell, value);
        if (t == null) {
            return null;
        }
        String[] availableChoices = excelCell.getAvailableChoices();
        if (Validator.isNullOrEmpty(availableChoices)) {
            return t;
        }
        Object[] choices = ConvertUtil.toArray(availableChoices, this.supportClass());
        if (ArrayUtils.contains(choices, t)) {
            return t;
        }
        throw new ExcelException(3, sheetNo, cellIndex, value, excelCell);
    }

    protected abstract T convertValue(int var1, String var2, ExcelCell var3, Object var4);
}

