/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.beanutils.converters;

import com.feilong.lib.beanutils.ConversionException;
import com.feilong.lib.beanutils.ConvertUtils;
import com.feilong.lib.beanutils.Converter;
import java.lang.reflect.Array;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConverter
implements Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConverter.class);
    private static final String DEFAULT_CONFIG_MSG = "(N.B. Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "org.apache.commons.beanutils.converters.";
    private boolean useDefault = false;
    private Object defaultValue = null;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public <T> T convert(Class<T> type, Object value) {
        if (type == null) {
            return this.convertToDefaultType(type, value);
        }
        Class<?> sourceType = value == null ? null : value.getClass();
        Class<T> targetType = ConvertUtils.primitiveToWrapper(type);
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(targetType);
        }
        sourceType = value.getClass();
        try {
            if (targetType.equals(String.class)) {
                return targetType.cast(this.convertToString(value));
            }
            if (targetType.equals(sourceType)) {
                return targetType.cast(value);
            }
            T result = this.convertToType(targetType, value);
            return targetType.cast(result);
        }
        catch (Throwable t) {
            return this.handleError(targetType, value, t);
        }
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected abstract <T> T convertToType(Class<T> var1, Object var2) throws Throwable;

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    protected <T> T handleError(Class<T> type, Object value, Throwable cause) {
        if (LOGGER.isDebugEnabled()) {
            if (cause instanceof ConversionException) {
                LOGGER.debug("    Conversion threw ConversionException: " + cause.getMessage());
            } else {
                LOGGER.debug("    Conversion threw " + cause);
            }
        }
        if (this.useDefault) {
            return this.handleMissing(type);
        }
        ConversionException cex = null;
        if (cause instanceof ConversionException) {
            cex = (ConversionException)cause;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("    Re-throwing ConversionException: " + cex.getMessage());
                LOGGER.debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
        } else {
            String msg = "Error converting from '" + this.toString(value.getClass()) + "' to '" + this.toString(type) + "' " + cause.getMessage();
            cex = new ConversionException(msg, cause);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("    Throwing ConversionException: " + msg);
                LOGGER.debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
        }
        throw cex;
    }

    protected <T> T handleMissing(Class<T> type) {
        if (this.useDefault || type.equals(String.class)) {
            Object value = this.getDefault(type);
            if (this.useDefault && value != null && !type.equals(value.getClass())) {
                try {
                    value = this.convertToType(type, this.defaultValue);
                }
                catch (Throwable t) {
                    throw new ConversionException("Default conversion to " + this.toString(type) + " failed.", t);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("    Using default " + (value == null ? "" : this.toString(value.getClass()) + " ") + "value '" + this.defaultValue + "'");
            }
            return type.cast(value);
        }
        ConversionException cex = new ConversionException("No value specified for '" + this.toString(type) + "'");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("    Throwing ConversionException: " + cex.getMessage());
            LOGGER.debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
        }
        throw cex;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class<?> getDefaultType();

    protected Object getDefault(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    String toString(Class<?> type) {
        String typeName = null;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }

    private <T> T convertToDefaultType(Class<T> targetClass, Object value) {
        Object result = this.convert(this.getDefaultType(), value);
        return (T)result;
    }

    protected ConversionException conversionException(Class<?> type, Object value) {
        return new ConversionException("Can't convert value '" + value + "' to type " + type);
    }
}

