/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.beanutils;

import com.feilong.lib.beanutils.ContextClassLoaderLocal;
import com.feilong.lib.beanutils.DynaClass;
import com.feilong.lib.beanutils.DynaProperty;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.beanutils.PropertyUtilsBean;
import com.feilong.lib.beanutils.WrapDynaBean;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.DynaBean;

public class WrapDynaClass
implements DynaClass {
    private String beanClassName = null;
    private Reference<Class<?>> beanClassRef = null;
    private final PropertyUtilsBean propertyUtilsBean;
    protected PropertyDescriptor[] descriptors = null;
    protected HashMap<String, PropertyDescriptor> descriptorsMap = new HashMap();
    protected DynaProperty[] properties = null;
    protected HashMap<String, DynaProperty> propertiesMap = new HashMap();
    private static final ContextClassLoaderLocal<Map<CacheKey, WrapDynaClass>> CLASSLOADER_CACHE = new ContextClassLoaderLocal<Map<CacheKey, WrapDynaClass>>(){

        @Override
        protected Map<CacheKey, WrapDynaClass> initialValue() {
            return new WeakHashMap<CacheKey, WrapDynaClass>();
        }
    };

    private WrapDynaClass(Class<?> beanClass, PropertyUtilsBean propUtils) {
        this.beanClassRef = new SoftReference(beanClass);
        this.beanClassName = beanClass.getName();
        this.propertyUtilsBean = propUtils;
        this.introspect();
    }

    private static Map<Object, Object> getDynaClassesMap() {
        Map<Object, Object> cache = CLASSLOADER_CACHE.get();
        return cache;
    }

    private static Map<CacheKey, WrapDynaClass> getClassesCache() {
        return CLASSLOADER_CACHE.get();
    }

    protected Class<?> getBeanClass() {
        return this.beanClassRef.get();
    }

    @Override
    public String getName() {
        return this.beanClassName;
    }

    @Override
    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return this.propertiesMap.get(name);
    }

    @Override
    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    @Override
    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new WrapDynaBean(this.getBeanClass().newInstance());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.descriptorsMap.get(name);
    }

    public static void clear() {
        WrapDynaClass.getClassesCache().clear();
    }

    public static WrapDynaClass createDynaClass(Class<?> beanClass) {
        return WrapDynaClass.createDynaClass(beanClass, null);
    }

    public static WrapDynaClass createDynaClass(Class<?> beanClass, PropertyUtilsBean pu) {
        PropertyUtilsBean propUtils = pu != null ? pu : PropertyUtilsBean.getInstance();
        CacheKey key = new CacheKey(beanClass, propUtils);
        WrapDynaClass dynaClass = WrapDynaClass.getClassesCache().get(key);
        if (dynaClass == null) {
            dynaClass = new WrapDynaClass(beanClass, propUtils);
            WrapDynaClass.getClassesCache().put(key, dynaClass);
        }
        return dynaClass;
    }

    protected PropertyUtilsBean getPropertyUtilsBean() {
        return this.propertyUtilsBean;
    }

    protected void introspect() {
        HashMap mappeds;
        Class<?> beanClass = this.getBeanClass();
        PropertyDescriptor[] regulars = this.getPropertyUtilsBean().getPropertyDescriptors(beanClass);
        if (regulars == null) {
            regulars = new PropertyDescriptor[]{};
        }
        if ((mappeds = PropertyUtils.getMappedPropertyDescriptors(beanClass)) == null) {
            mappeds = new HashMap();
        }
        this.properties = new DynaProperty[regulars.length + mappeds.size()];
        for (int i = 0; i < regulars.length; ++i) {
            this.descriptorsMap.put(regulars[i].getName(), regulars[i]);
            this.properties[i] = new DynaProperty(regulars[i].getName(), regulars[i].getPropertyType());
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
        int j = regulars.length;
        for (String name : mappeds.keySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)mappeds.get(name);
            this.properties[j] = new DynaProperty(descriptor.getName(), Map.class);
            this.propertiesMap.put(this.properties[j].getName(), this.properties[j]);
            ++j;
        }
    }

    private static class CacheKey {
        private final Class<?> beanClass;
        private final PropertyUtilsBean propUtils;

        public CacheKey(Class<?> beanCls, PropertyUtilsBean pu) {
            this.beanClass = beanCls;
            this.propUtils = pu;
        }

        public int hashCode() {
            int factor = 31;
            int result = 17;
            result = 31 * this.beanClass.hashCode() + result;
            result = 31 * this.propUtils.hashCode() + result;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey c = (CacheKey)obj;
            return this.beanClass.equals(c.beanClass) && this.propUtils.equals(c.propUtils);
        }
    }
}

