/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json;

import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.json.JsonToJavaConfig;
import com.feilong.json.JsonUtil;
import com.feilong.json.builder.JsonConfigBuilder;
import com.feilong.lib.collection4.IteratorUtils;
import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.JSONUtils;
import com.feilong.lib.lang3.ClassUtils;
import java.util.Iterator;
import java.util.List;

public final class JsonHelper {
    private static final JsonConfig DEFAULT_JSON_CONFIG_INSTANCE = new JsonConfig();

    private JsonHelper() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static <T> T transformerValue(Object value, JsonToJavaConfig jsonToJavaConfig) {
        if (JSONNull.getInstance().equals(value)) {
            return null;
        }
        boolean noRootClass = null == jsonToJavaConfig || null == jsonToJavaConfig.getRootClass();
        return (T)(noRootClass ? value : JsonUtil.toBean(value, jsonToJavaConfig));
    }

    static JSON toJSON(Object obj, JsonConfig jsonConfig) {
        JsonConfig useJsonConfig = ObjectUtil.defaultIfNull(jsonConfig, JsonConfigBuilder.DEFAULT_JAVA_TO_JSON_CONFIG);
        if (JsonHelper.isNeedConvertToJSONArray(obj)) {
            List arrayJsonObject = obj instanceof Iterator ? IteratorUtils.toList((Iterator)((Object)obj)) : obj;
            return JsonHelper.toJSONArray(arrayJsonObject, useJsonConfig);
        }
        return JsonHelper.toJSONObject(obj, useJsonConfig);
    }

    private static boolean isNeedConvertToJSONArray(Object obj) {
        String str;
        if (obj instanceof String && (str = (String)obj).startsWith("[") && str.endsWith("]")) {
            return true;
        }
        return JSONUtils.isArray(obj) || obj instanceof Enum || obj instanceof Iterator;
    }

    public static boolean isCommonString(Object obj) {
        if (!ClassUtil.isInstance(obj, String.class)) {
            return false;
        }
        String str = (String)obj;
        if (str.startsWith("[") && str.endsWith("]")) {
            return false;
        }
        return !str.startsWith("{") || !str.endsWith("}");
    }

    static boolean isKeyValueJsonString(Object obj) {
        if (!ClassUtil.isInstance(obj, String.class)) {
            return false;
        }
        if (null == obj) {
            return false;
        }
        String str = (String)obj;
        return str.startsWith("{") && str.endsWith("}");
    }

    static JSONArray toJSONArray(Object obj, JsonConfig useJsonConfig) {
        return JSONArray.fromObject(obj, ObjectUtil.defaultIfNull(useJsonConfig, DEFAULT_JSON_CONFIG_INSTANCE));
    }

    static JSONObject toJSONObject(Object object, JsonConfig useJsonConfig) {
        return JSONObject.fromObject(object, ObjectUtil.defaultIfNull(useJsonConfig, DEFAULT_JSON_CONFIG_INSTANCE));
    }

    static <V> boolean isAllowFormatType(V value, Class<?> ... allowClassTypes) {
        if (null == value) {
            return true;
        }
        Class<?> klassClass = value.getClass();
        return ClassUtils.isPrimitiveOrWrapper(klassClass) || String.class == klassClass || ObjectUtil.isArray(value) || ClassUtil.isInstanceAnyClass(value, allowClassTypes);
    }
}

