/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.io;

import com.feilong.core.Validate;
import com.feilong.core.lang.StringUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.ReaderUtil;
import com.feilong.lib.io.IOUtils;
import com.feilong.lib.springframework.core.io.DefaultResourceLoader;
import com.feilong.lib.springframework.core.io.Resource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputStreamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamUtil.class);

    private InputStreamUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static InputStream getInputStream(String location) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource(location);
        try {
            return resource.getInputStream();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("[{}] use DefaultResourceLoader not found,will convert to FileInputStream.Suggest you try use [file://] or [classpath:] to improve the parse speed", (Object)location);
            return FileUtil.getFileInputStream(location);
        }
        catch (IOException e) {
            throw new UncheckedIOException("location:[" + location + "]", e);
        }
    }

    public static InputStream newByteArrayInputStream(String str, String charsetType) {
        Validate.notNull(str, "str can't be null!", new Object[0]);
        return new ByteArrayInputStream(StringUtil.getBytes(str, charsetType));
    }

    public static String toString(InputStream inputStream) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        Charset defaultCharset = Charset.defaultCharset();
        String charsetName = defaultCharset.name();
        LOGGER.debug("will use defaultCharset:[{}]", (Object)charsetName);
        return InputStreamUtil.toString(inputStream, charsetName);
    }

    public static String toString(InputStream inputStream, String charsetName) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        BufferedReader reader = InputStreamUtil.toBufferedReader(inputStream, charsetName);
        return ReaderUtil.toString(reader);
    }

    public static BufferedReader toBufferedReader(InputStream inputStream, String charsetName) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, charsetName);
            return IOUtils.toBufferedReader(reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }
}

