/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.formatter.builder;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.formatter.builder.FormatterBuilder;
import com.feilong.formatter.builder.FormatterColumnEntityListSorter;
import com.feilong.formatter.builder.ValueHandler;
import com.feilong.formatter.entity.BeanFormatterConfig;
import com.feilong.formatter.entity.FormatterColumnEntity;
import com.feilong.json.JsonUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFormatterBuilder
implements FormatterBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFormatterBuilder.class);

    @Override
    public <T> List<FormatterColumnEntity> build(T bean, BeanFormatterConfig beanFormatterConfig) {
        BeanFormatterConfig useBeanFormatterConfig = null == beanFormatterConfig ? new BeanFormatterConfig() : beanFormatterConfig;
        List<FormatterColumnEntity> formatterColumnEntityList = this.buildFormatterColumnEntityList(bean, useBeanFormatterConfig);
        return AbstractFormatterBuilder.handler(formatterColumnEntityList, useBeanFormatterConfig);
    }

    private static List<FormatterColumnEntity> handler(List<FormatterColumnEntity> formatterColumnEntityList, BeanFormatterConfig useBeanFormatterConfig) {
        List<FormatterColumnEntity> useFormatterColumnEntityList;
        Validate.notNull(useBeanFormatterConfig, "useBeanFormatterConfig can't be null!", new Object[0]);
        String[] includePropertyNames = useBeanFormatterConfig.getIncludePropertyNames();
        List<FormatterColumnEntity> list = useFormatterColumnEntityList = Validator.isNotNullOrEmpty(includePropertyNames) ? CollectionsUtil.select(formatterColumnEntityList, "name", includePropertyNames) : formatterColumnEntityList;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("before sort:{}", (Object)JsonUtil.format(useFormatterColumnEntityList));
        }
        List<FormatterColumnEntity> result = FormatterColumnEntityListSorter.sortFormatterColumnEntityList(useFormatterColumnEntityList, useBeanFormatterConfig);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("after sort:{}", (Object)JsonUtil.format(result));
        }
        return result;
    }

    protected static Object[] buildLineData(Map<String, Object> propertyValueMap, BeanFormatterConfig beanFormatterConfig) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("propertyValueMap:{}", (Object)JsonUtil.format(propertyValueMap, 0, 0));
        }
        int j = 0;
        Object[] rowData = new Object[propertyValueMap.size()];
        for (Map.Entry<String, Object> entry : propertyValueMap.entrySet()) {
            String propertyName = entry.getKey();
            Object value = entry.getValue();
            rowData[j] = Validator.isNullOrEmpty(value) ? "" : ValueHandler.getValue(propertyName, value, beanFormatterConfig);
            ++j;
        }
        return rowData;
    }

    protected abstract <T> List<FormatterColumnEntity> buildFormatterColumnEntityList(T var1, BeanFormatterConfig var2);
}

