/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.formatter;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.formatter.AbstractFormatter;
import com.feilong.formatter.builder.ColumnMaxWidthsBuilder;
import com.feilong.lib.collection4.CollectionUtils;
import com.feilong.lib.lang3.StringUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTableFormatter
extends AbstractFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleTableFormatter.class);

    @Override
    public String format(String[] columnTitles, List<Object[]> dataList) {
        Date beginDate = DateUtil.now();
        List<Object[]> rows = SimpleTableFormatter.combinRowsData(columnTitles, dataList);
        if (Validator.isNullOrEmpty(rows)) {
            return "";
        }
        int[] colWidths = ColumnMaxWidthsBuilder.build(rows);
        if (null != columnTitles) {
            SimpleTableFormatter.insertSplitorLine(rows, colWidths);
        }
        StringBuilder sb = new StringBuilder();
        for (Object[] cells : rows) {
            sb.append((CharSequence)SimpleTableFormatter.formatRowInfo(cells, colWidths)).append(System.lineSeparator());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("format use time:[{}]", (Object)DateUtil.formatDuration(beginDate));
        }
        return System.lineSeparator() + sb.toString();
    }

    private static StringBuilder formatRowInfo(Object[] cells, int[] colWidths) {
        StringBuilder sb = new StringBuilder();
        for (int colNum = 0; colNum < cells.length; ++colNum) {
            sb.append(StringUtils.rightPad(StringUtils.defaultString(ConvertUtil.toString(cells[colNum])), colWidths[colNum]));
            sb.append(" ");
        }
        return sb;
    }

    private static void insertSplitorLine(List<Object[]> rows, int[] colWidths) {
        String[] borders = ArrayUtil.newArray(String.class, colWidths.length);
        for (int i = 0; i < borders.length; ++i) {
            borders[i] = StringUtils.repeat("-", colWidths[i]);
        }
        rows.add(1, borders);
    }

    private static List<Object[]> combinRowsData(String[] columnTitles, List<Object[]> dataList) {
        List<Object[]> rows = CollectionsUtil.newArrayList();
        CollectionUtils.addIgnoreNull(rows, columnTitles);
        CollectionsUtil.addAllIgnoreNull(rows, dataList);
        return rows;
    }
}

