/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.util.CellReferenceUtil;
import com.feilong.excel.writer.BlockLoopHorizontalWriter;
import com.feilong.excel.writer.BlockLoopVerticalWriter;
import com.feilong.excel.writer.BlockSimpleWriter;
import com.feilong.json.JsonUtil;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SheetWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SheetWriter.class);
    private static final String SHEET_NAME = "sheetName";

    private SheetWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void write(Sheet sheet, ExcelSheet excelSheet, Map<String, CellStyle> styleMap, Object ognlData) {
        Date beginDate = new Date();
        OgnlStack ognlStack = new OgnlStack(ognlData);
        SheetWriter.setSheetName(sheet, excelSheet, ognlStack);
        List<ExcelBlock> sortedExcelBlocks = excelSheet.getSortedExcelBlocks();
        Map<ExcelBlock, List<CellRangeAddress>> mergedRegionsMap = SheetWriter.buildMergedRegions(sheet, sortedExcelBlocks);
        for (ExcelBlock excelBlock : sortedExcelBlocks) {
            SheetWriter.write(sheet, excelSheet, excelBlock, styleMap, mergedRegionsMap, ognlStack);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("writeSheet:[{}], use time: [{}]", (Object)excelSheet.getName(), (Object)DateUtil.formatDuration(beginDate));
        }
    }

    private static void write(Sheet sheet, ExcelSheet excelSheet, ExcelBlock excelBlock, Map<String, CellStyle> styleMap, Map<ExcelBlock, List<CellRangeAddress>> mergedRegionsMap, OgnlStack ognlStack) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("excelBlock:{}", (Object)JsonUtil.format(excelBlock));
        }
        Date blockBeginDate = new Date();
        if (excelBlock.isLoop()) {
            List<CellRangeAddress> cellRangeAddressList = mergedRegionsMap.get(excelBlock);
            boolean isHorizontal = excelBlock.getDirection().equalsIgnoreCase("horizontal");
            if (isHorizontal) {
                BlockLoopHorizontalWriter.write(sheet, excelBlock, ognlStack, cellRangeAddressList, styleMap);
            } else {
                BlockLoopVerticalWriter.write(sheet, excelBlock, ognlStack, cellRangeAddressList, styleMap);
            }
        } else {
            BlockSimpleWriter.write(sheet, excelBlock, ognlStack, styleMap);
        }
        if (LOGGER.isDebugEnabled()) {
            String pattern = "write sheet block:[{}]-[{}], use time: [{}]";
            LOGGER.debug(pattern, new Object[]{excelSheet.getName(), excelBlock.getDataName(), DateUtil.formatDuration(blockBeginDate)});
        }
    }

    private static Map<ExcelBlock, List<CellRangeAddress>> buildMergedRegions(Sheet sheet, List<ExcelBlock> sortedExcelBlocks) {
        int numMergedRegions = sheet.getNumMergedRegions();
        HashMap<ExcelBlock, List<CellRangeAddress>> mergedRegions = new HashMap<ExcelBlock, List<CellRangeAddress>>();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int firstRow = cellRangeAddress.getFirstRow();
            int firstColumn = cellRangeAddress.getFirstColumn();
            int lastRow = cellRangeAddress.getLastRow();
            int lastColumn = cellRangeAddress.getLastColumn();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Merged Region:[{}-{}]", (Object)CellReferenceUtil.getCellRef(firstRow, firstColumn), (Object)CellReferenceUtil.getCellRef(lastRow, lastColumn));
            }
            for (ExcelBlock blockDefinition : sortedExcelBlocks) {
                int startRow = blockDefinition.getStartRow();
                int endRow = blockDefinition.getEndRow();
                int startCol = blockDefinition.getStartCol();
                int endCol = blockDefinition.getEndCol();
                if (firstRow < startRow || firstColumn < startCol || lastRow > endRow || lastColumn > endCol) continue;
                ArrayList<CellRangeAddress> cellRangeAddressList = (ArrayList<CellRangeAddress>)mergedRegions.get(blockDefinition);
                if (cellRangeAddressList == null) {
                    cellRangeAddressList = new ArrayList<CellRangeAddress>();
                    mergedRegions.put(blockDefinition, cellRangeAddressList);
                }
                cellRangeAddressList.add(cellRangeAddress);
            }
        }
        return mergedRegions;
    }

    private static void setSheetName(Sheet sheet, ExcelSheet excelSheet, OgnlStack ognlStack) {
        String sheetName = SheetWriter.getSheetName(excelSheet, ognlStack);
        if (sheetName != null) {
            Workbook workbook = sheet.getWorkbook();
            int sheetIndex = workbook.getSheetIndex(sheet);
            LOGGER.debug("set workbook sheet:[{}] name:[{}]", (Object)sheetIndex, (Object)sheetName);
            workbook.setSheetName(sheetIndex, sheetName);
        }
    }

    private static String getSheetName(ExcelSheet excelSheet, OgnlStack ognlStack) {
        String sheetNameStack = ObjectUtil.defaultIfNullOrEmpty((String)ognlStack.getValue(SHEET_NAME), "");
        String sheetDisplayName = excelSheet.getDisplayName();
        LOGGER.debug("excelSheet DisplayName:[{}],stack value:[{}]", (Object)sheetDisplayName, (Object)sheetNameStack);
        return ObjectUtil.defaultIfNullOrEmpty(sheetNameStack, sheetDisplayName);
    }
}

