/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.definition.ExcelCellConditionStyle;
import com.feilong.excel.writer.BlockCopyer;
import com.feilong.excel.writer.BlockStyleSetter;
import com.feilong.excel.writer.CellStyleSetter;
import com.feilong.excel.writer.CellValueSetter;
import com.feilong.excel.writer.ColumnWriter;
import com.feilong.excel.writer.DataToCollectionUtil;
import com.feilong.excel.writer.FormulaEvaluatorUtil;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RowWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowWriter.class);

    private RowWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void write(Sheet sheet, ExcelBlock excelBlock, int rowOffset, List<CellRangeAddress> mergedRegions, Map<String, CellStyle> styleMap, OgnlStack ognlStack) {
        if (rowOffset > 0) {
            int startRow = excelBlock.getStartRow();
            int startCol = excelBlock.getStartCol();
            int endRow = excelBlock.getEndRow();
            int endCol = excelBlock.getEndCol();
            BlockCopyer.copy(sheet, startRow, startCol, endRow, endCol, rowOffset, 0, mergedRegions);
        }
        if (Validator.isNotNullOrEmpty(styleMap)) {
            RowWriter.setStyle(sheet, excelBlock, rowOffset, styleMap, ognlStack);
        }
        RowWriter.writeCells(sheet, excelBlock, rowOffset, styleMap, ognlStack);
        ExcelBlock childBlock = excelBlock.getChildBlock();
        if (childBlock != null) {
            RowWriter.writeChildBlock(sheet, childBlock, rowOffset, mergedRegions, styleMap, ognlStack);
        }
    }

    private static void writeCells(Sheet sheet, ExcelBlock excelBlock, int rowOffset, Map<String, CellStyle> styleMap, OgnlStack ognlStack) {
        Date beginDate = new Date();
        int rowIndex = 0;
        for (ExcelCell excelCell : excelBlock.getCells()) {
            String dataName = RowWriter.buildDataName(rowOffset, excelCell);
            rowIndex = excelCell.getRow() + rowOffset;
            int col = excelCell.getCol();
            CellValueSetter.set(sheet, rowIndex, col, dataName, ognlStack);
            RowWriter.setCellStyle(sheet, styleMap, ognlStack, excelCell, rowIndex, col);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("write row:[{}] over,rowOffset:[{}],use time: [{}]", new Object[]{rowIndex, rowOffset, DateUtil.formatDuration(beginDate)});
        }
    }

    private static void setCellStyle(Sheet sheet, Map<String, CellStyle> styleMap, OgnlStack ognlStack, ExcelCell excelCell, int rowIndex, int col) {
        if (Validator.isNullOrEmpty(styleMap)) {
            return;
        }
        for (ExcelCellConditionStyle style : excelCell.getStyles()) {
            Object obj = ognlStack.getValue(style.getCondition());
            if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            CellStyleSetter.set(sheet, rowIndex, col, styleMap.get(style.getCellIndex()));
        }
    }

    private static String buildDataName(int rowOffset, ExcelCell excelCell) {
        String dataName = ObjectUtil.defaultIfNullOrEmpty(excelCell.getDataExpr(), excelCell.getDataName());
        if (dataName.startsWith("=")) {
            return FormulaEvaluatorUtil.offsetFormula(dataName, rowOffset, 0);
        }
        return dataName;
    }

    private static void setStyle(Sheet sheet, ExcelBlock excelBlock, int rowOffset, Map<String, CellStyle> styleMap, OgnlStack ognlStack) {
        for (ExcelCellConditionStyle style : excelBlock.getStyles()) {
            Object obj = ognlStack.getValue(style.getCondition());
            if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            int startRow = style.getStartRow();
            int endRow = style.getEndRow();
            int startCol = style.getStartCol();
            int endCol = style.getEndCol();
            String cellIndex = style.getCellIndex();
            BlockStyleSetter.set(sheet, startRow + rowOffset, endRow + rowOffset, startCol, endCol, cellIndex, styleMap);
        }
    }

    private static void writeChildBlock(Sheet sheet, ExcelBlock childBlock, int rowOffset, List<CellRangeAddress> mergedRegions, Map<String, CellStyle> styleMap, OgnlStack ognlStack) {
        Object colValue = ognlStack.getValue(childBlock.getDataName());
        if (colValue == null) {
            return;
        }
        Collection<?> listValue = DataToCollectionUtil.convert(colValue);
        ArrayList<CellRangeAddress> childMergedRegions = null;
        int startCol = childBlock.getStartCol();
        int endCol = childBlock.getEndCol();
        if (mergedRegions != null) {
            childMergedRegions = new ArrayList<CellRangeAddress>();
            for (CellRangeAddress cellRangeAddress : mergedRegions) {
                int firstRow = cellRangeAddress.getFirstRow();
                int firstColumn = cellRangeAddress.getFirstColumn();
                int lastRow = cellRangeAddress.getLastRow();
                int lastColumn = cellRangeAddress.getLastColumn();
                int startRow = childBlock.getStartRow();
                int endRow = childBlock.getEndRow();
                if (firstRow < startRow || firstColumn < startCol || lastRow > endRow || lastColumn > endCol) continue;
                childMergedRegions.add(cellRangeAddress);
            }
        }
        int colStep = 0;
        Object preObj = null;
        for (Object obj : listValue) {
            ognlStack.push(obj);
            ognlStack.addContext("preColumn", preObj);
            ognlStack.addContext("columnNum", colStep);
            int colOffset = colStep * (endCol - startCol + 1);
            ColumnWriter.write(sheet, childBlock, ognlStack, rowOffset, colOffset, childMergedRegions, styleMap);
            ++colStep;
            preObj = ognlStack.pop();
        }
        ognlStack.removeContext("preColumn");
        ognlStack.removeContext("columnNum");
    }
}

