/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.date.DateUtil;
import com.feilong.excel.util.CellReferenceUtil;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaEvaluatorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormulaEvaluatorUtil.class);
    private static final Pattern DYNAMIC_CELL_PATTREN = Pattern.compile("[A-Z][A-Z]?\\d+");

    private FormulaEvaluatorUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void reCalculate(Workbook workbook) {
        Date beginDate = new Date();
        FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            Sheet sheet = workbook.getSheetAt(sheetNum);
            for (Row row : sheet) {
                for (Cell cell : row) {
                    if (cell.getCellType() != CellType.FORMULA) continue;
                    formulaEvaluator.evaluateFormulaCell(cell);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("reCalculate workbook use time: [{}]", (Object)DateUtil.formatDuration(beginDate));
        }
    }

    static String offsetFormula(String formula, int rowOffset, int colOffset) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = DYNAMIC_CELL_PATTREN.matcher(formula);
        int head = 0;
        int start = 0;
        int end = -1;
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            sb.append(formula.substring(head, start));
            sb.append(CellReferenceUtil.getCellRef(formula.substring(start, end), rowOffset, colOffset));
            head = end;
        }
        sb.append(formula.substring(head));
        return sb.toString();
    }
}

