/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.Validator;
import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.util.CellReferenceUtil;
import com.feilong.excel.writer.DataToCollectionUtil;
import com.feilong.excel.writer.RowWriter;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockLoopHorizontalWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockLoopHorizontalWriter.class);

    private BlockLoopHorizontalWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void write(Sheet sheet, ExcelBlock excelBlock, OgnlStack ognlStack, List<CellRangeAddress> mergedRegions, Map<String, CellStyle> styleMap) {
        Object value = ognlStack.getValue(excelBlock.getDataName());
        int startRow = excelBlock.getStartRow();
        int endRow = excelBlock.getEndRow();
        if (value == null) {
            for (int i = endRow; i >= startRow; --i) {
                sheet.removeRow(sheet.getRow(i));
            }
            return;
        }
        Collection<?> listValue = DataToCollectionUtil.convert(value);
        BlockLoopHorizontalWriter.writeData(sheet, excelBlock, ognlStack, mergedRegions, styleMap, listValue);
        BlockLoopHorizontalWriter.removeMergedRegion(sheet, excelBlock, startRow, endRow);
        for (int i = excelBlock.getEndRow(); i >= excelBlock.getStartRow(); --i) {
            Row row = sheet.getRow(i);
            sheet.removeRow(row);
        }
        if (Validator.isNotNullOrEmpty(listValue)) {
            sheet.shiftRows(endRow + 1, sheet.getLastRowNum(), startRow - endRow - 1, true, false);
        }
    }

    private static void writeData(Sheet sheet, ExcelBlock excelBlock, OgnlStack ognlStack, List<CellRangeAddress> mergedRegions, Map<String, CellStyle> styleMap, Collection<?> listValue) {
        int startRow = excelBlock.getStartRow();
        int endRow = excelBlock.getEndRow();
        Object preObj = null;
        int lastRowNum = sheet.getLastRowNum();
        int step = 1;
        for (Object obj : listValue) {
            int nextStartRow;
            ognlStack.push(obj);
            ognlStack.addContext("preLine", preObj);
            ognlStack.addContext("lineNum", step - 1);
            int rowOffset = step * (endRow - startRow + 1);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("startRow:[{}],endRow:[{}],step:[{}],rowOffset:[{}]", new Object[]{startRow, endRow, step, rowOffset});
            }
            if ((nextStartRow = startRow + rowOffset) <= lastRowNum) {
                sheet.shiftRows(nextStartRow, lastRowNum, endRow - startRow + 1, true, false);
            }
            RowWriter.write(sheet, excelBlock, rowOffset, mergedRegions, styleMap, ognlStack);
            ++step;
            preObj = ognlStack.pop();
        }
        ognlStack.removeContext("preLine");
        ognlStack.removeContext("lineNum");
    }

    private static void removeMergedRegion(Sheet sheet, ExcelBlock excelBlock, int startRow, int endRow) {
        for (int i = sheet.getNumMergedRegions() - 1; i >= 0; --i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int lastRow = cellRangeAddress.getLastRow();
            int firstRow = cellRangeAddress.getFirstRow();
            int firstColumn = cellRangeAddress.getFirstColumn();
            int lastColumn = cellRangeAddress.getLastColumn();
            int startCol = excelBlock.getStartCol();
            int endCol = excelBlock.getEndCol();
            if (firstRow < startRow || firstColumn < startCol || lastRow > endRow || lastColumn > endCol) continue;
            sheet.removeMergedRegion(i);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Removed Merged Region:[{}-{}]", (Object)CellReferenceUtil.getCellRef(firstRow, firstColumn), (Object)CellReferenceUtil.getCellRef(lastRow, lastColumn));
        }
    }
}

