/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.util;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Date;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbookUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbookUtil.class);

    private WorkbookUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Workbook create(InputStream inputStream) {
        Validate.notNull(inputStream, "inputStream can't be null!", new Object[0]);
        Date beginDate = new Date();
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("create workbook from [{}],use time: [{}]", (Object)inputStream, (Object)DateUtil.formatDuration(beginDate));
            }
            return workbook;
        }
        catch (EncryptedDocumentException e) {
            throw new DefaultRuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Workbook workbook, OutputStream outputStream) {
        Validate.notNull(workbook, "workbook can't be null!", new Object[0]);
        Validate.notNull(outputStream, "outputStream can't be null!", new Object[0]);
        Date beginDate = new Date();
        try {
            workbook.write(outputStream);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("write workbook to outputStream use time: [{}]", (Object)DateUtil.formatDuration(beginDate));
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(new Closeable[]{workbook, outputStream});
                throw throwable;
            }
        }
        IOUtil.closeQuietly(new Closeable[]{workbook, outputStream});
    }
}

