/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.util.DigesterCreater;
import com.feilong.io.InputStreamUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.collection4.CollectionUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester3.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExcelSheetMapBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelSheetMapBuilder.class);
    private static final Digester DIGESTER = DigesterCreater.create("classpath:config/excel/definition-rule.xml");

    private ExcelSheetMapBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Map<String, ExcelSheet> build(String ... sheetDefinitionLocations) {
        Validate.notEmpty(sheetDefinitionLocations, "sheetDefinitionLocations can't be null/empty!", new Object[0]);
        Map<String, ExcelSheet> sheetDefinitionsMap = MapUtil.newLinkedHashMap(sheetDefinitionLocations.length);
        for (String sheetDefinitionPath : sheetDefinitionLocations) {
            Validate.notBlank(sheetDefinitionPath, "sheetDefinitionPath can't be blank!", new Object[0]);
            try {
                Date beginDate = new Date();
                List excelSheetList = (List)DIGESTER.parse(InputStreamUtil.getInputStream(sheetDefinitionPath));
                for (ExcelSheet excelSheet : excelSheetList) {
                    sheetDefinitionsMap.put(ObjectUtil.defaultIfNullOrEmpty(excelSheet.getName(), ""), excelSheet);
                }
                if (!LOGGER.isDebugEnabled()) continue;
                int size = CollectionUtils.size(excelSheetList);
                LOGGER.debug("parse [{}],sheetList size:[{}],use time: [{}]", new Object[]{sheetDefinitionPath, size, DateUtil.formatDuration(beginDate)});
            }
            catch (Exception e) {
                throw new DefaultRuntimeException("parse [" + sheetDefinitionPath + "] fail", e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parse sheetDefinitionLocations:[{}],sheetDefinitionsMap:[{}]", (Object)sheetDefinitionLocations, (Object)JsonUtil.format(sheetDefinitionsMap));
        }
        return sheetDefinitionsMap;
    }
}

