/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.util.SheetNamesUtil;
import com.feilong.lib.collection4.MapUtils;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDefinitionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelDefinitionBuilder.class);

    private ExcelDefinitionBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static ExcelDefinition build(Map<String, ExcelSheet> sheetDefinitionMap, String ... sheetNames) {
        ExcelDefinition excelDefinition = new ExcelDefinition();
        ArrayList<ExcelSheet> excelSheets = new ArrayList<ExcelSheet>();
        if (SheetNamesUtil.isEmptyOrNullElement(sheetNames) && MapUtils.size(sheetDefinitionMap) == 1) {
            LOGGER.debug("sheetNames isEmptyOrNullElement,and sheetDefinitionMap is only 1,use ExcelSheet");
            excelSheets.addAll(sheetDefinitionMap.values());
        } else {
            for (String sheetName : sheetNames) {
                excelSheets.add(ExcelDefinitionBuilder.toExcelSheet(sheetDefinitionMap, sheetName));
            }
        }
        excelDefinition.setExcelSheets(ConvertUtil.toList(sheetDefinitionMap.values()));
        return excelDefinition;
    }

    private static ExcelSheet toExcelSheet(Map<String, ExcelSheet> sheetDefinitions, String sheetName) {
        if ("blank".equalsIgnoreCase(sheetName)) {
            return new ExcelSheet();
        }
        ExcelSheet excelSheet = sheetDefinitions.get(sheetName);
        Validate.notNull(excelSheet, "No sheet defintion found with name: %s", sheetName);
        return excelSheet;
    }
}

