/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validate;
import com.feilong.excel.AbstractExcelConfig;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.ExcelReader;
import com.feilong.excel.definition.ExcelSheet;
import com.feilong.excel.reader.ReadStatus;
import com.feilong.excel.reader.SheetReader;
import com.feilong.excel.util.CloneUtil;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class DefaultExcelReader
extends AbstractExcelConfig
implements ExcelReader {
    private boolean skipErrors = true;

    public DefaultExcelReader() {
    }

    public DefaultExcelReader(ExcelDefinition excelDefinition) {
        this.excelDefinition = excelDefinition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadStatus readAll(InputStream inputStream, Map<String, Object> beans) {
        ReadStatus readStatus = new ReadStatus();
        readStatus.setStatus(0);
        try (Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            List<ExcelSheet> excelSheets = this.excelDefinition.getExcelSheets();
            int size = excelSheets.size();
            Validate.isTrue(size > 0 && workbook.getNumberOfSheets() >= size, "No sheet definition found or Sheet Number in definition is more than number in file.", new Object[0]);
            OgnlStack ognlStack = new OgnlStack(beans);
            for (int i = 0; i < size; ++i) {
                SheetReader.readSheet(workbook, i, excelSheets.get(i), ognlStack, readStatus, this.skipErrors);
            }
            ReadStatus readStatus2 = readStatus;
            return readStatus2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadStatus readAllPerSheet(InputStream inputStream, Map<String, Object> data) {
        try (Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            List<ExcelSheet> excelSheets = this.excelDefinition.getExcelSheets();
            int size = excelSheets.size();
            Validate.isTrue(size > 0, "No sheet definition found", new Object[0]);
            ExcelSheet excelSheet = excelSheets.iterator().next();
            HashMap cacheMap = new HashMap();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                cacheMap.put(key, new ArrayList());
            }
            ReadStatus readStatus = new ReadStatus();
            readStatus.setStatus(0);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Map<String, Object> clonedData = CloneUtil.cloneMap(data);
                SheetReader.readSheet(workbook, i, excelSheet, new OgnlStack(clonedData), readStatus, this.skipErrors);
                for (String key : clonedData.keySet()) {
                    ((List)cacheMap.get(key)).add(clonedData.get(key));
                }
            }
            for (String key : data.keySet()) {
                if (cacheMap.containsKey(key)) {
                    data.put(key, cacheMap.get(key));
                    continue;
                }
                data.put(key, null);
            }
            ReadStatus readStatus2 = readStatus;
            return readStatus2;
        }
        catch (Exception e) {
            throw new DefaultRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadStatus readSheet(InputStream inputStream, int sheetNo, Map<String, Object> beans) {
        OgnlStack ognlStack = new OgnlStack(beans);
        try (Workbook workbook = WorkbookFactory.create((InputStream)inputStream);){
            List<ExcelSheet> excelSheets = this.excelDefinition.getExcelSheets();
            ReadStatus readStatus = new ReadStatus();
            readStatus.setStatus(0);
            SheetReader.readSheet(workbook, sheetNo, excelSheets.iterator().next(), ognlStack, readStatus, this.skipErrors);
            ReadStatus readStatus2 = readStatus;
            return readStatus2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isSkipErrors() {
        return this.skipErrors;
    }

    public void setSkipErrors(boolean skipErrors) {
        this.skipErrors = skipErrors;
    }
}

