/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.csv.handler;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.csv.entity.CsvColumnEntity;
import com.feilong.json.JsonUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataListBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataListBuilder.class);

    private DataListBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> List<Object[]> build(Iterable<T> iterable, List<CsvColumnEntity> csvColumnEntityList) {
        List<String> propertyNameList = CollectionsUtil.getPropertyValueList(csvColumnEntityList, "propertyName");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("propertyNameList:{}", (Object)JsonUtil.format(propertyNameList, 0, 0));
        }
        List<Object[]> dataList = CollectionsUtil.newArrayList();
        for (T t : iterable) {
            dataList.add(DataListBuilder.toObjectArray(t, propertyNameList));
        }
        return dataList;
    }

    private static <T> Object[] toObjectArray(T bean, List<String> propertyNameList) {
        Map propertyValueMap = MapUtil.newLinkedHashMap();
        PropertyUtil.copyProperties(propertyValueMap, bean, ConvertUtil.toStrings(propertyNameList));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("propertyValueMap:{}", (Object)JsonUtil.format(propertyValueMap, 0, 0));
        }
        int j = 0;
        Object[] rowData = new Object[propertyNameList.size()];
        for (Map.Entry entry : propertyValueMap.entrySet()) {
            Object value = entry.getValue();
            rowData[j] = Validator.isNullOrEmpty(value) ? "" : ConvertUtil.toString(value);
            ++j;
        }
        return rowData;
    }
}

