/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.csv.handler;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.csv.entity.CsvConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvContentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvContentBuilder.class);
    private static final char ESCAPE_CHARACTER = '\"';
    private static final char DEFAULT_QUOTE_CHARACTER = '\"';
    private static final char NO_QUOTE_CHARACTER = '\u0000';

    private CsvContentBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static final String build(List<Object[]> allLines, CsvConfig csvConfig) {
        StringBuilder sb = new StringBuilder();
        int j = allLines.size();
        for (int i = 0; i < j; ++i) {
            sb.append((CharSequence)CsvContentBuilder.buildLine(allLines.get(i), csvConfig));
            if (i == j - 1) continue;
            sb.append(System.lineSeparator());
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}{}", (Object)System.lineSeparator(), (Object)sb);
        }
        return sb.toString();
    }

    private static final StringBuilder buildLine(Object[] lineColumns, CsvConfig csvConfig) {
        StringBuilder sb = new StringBuilder();
        int lineLength = lineColumns.length;
        for (int i = 0; i < lineLength; ++i) {
            if (i != 0) {
                sb.append(csvConfig.getSeparator());
            }
            if (null == lineColumns[i]) continue;
            CsvContentBuilder.appendColumnValue(sb, ConvertUtil.toString(lineColumns[i]), '\"');
        }
        return sb;
    }

    private static void appendColumnValue(StringBuilder sb, String columnValue, char quotechar) {
        if (quotechar != '\u0000') {
            sb.append(quotechar);
        }
        CsvContentBuilder.appendByChar(sb, columnValue, quotechar);
        if (quotechar != '\u0000') {
            sb.append(quotechar);
        }
    }

    private static void appendByChar(StringBuilder sb, String columnValue, char quotechar) {
        int length = columnValue.length();
        for (int j = 0; j < length; ++j) {
            char currentChar = columnValue.charAt(j);
            if (currentChar == quotechar || currentChar == '\"') {
                sb.append('\"');
            }
            sb.append(currentChar);
        }
    }
}

